const { Schema, model } = require('mongoose');
const mongoosePaginate = require('mongoose-paginate-v2');

const ExpedientesUsuarios = new Schema({
  despacho: {
    type: Schema.Types.ObjectId,
    ref: 'despachos',
    required: true,
    index: true
  },
  expediente: {
    type: Schema.Types.ObjectId,
    ref: 'expedientes',
    required: true,
    index: true
  },
  usuario: {
    type: Schema.Types.ObjectId,
    ref: 'usuarios',
    required: true,
    index: true
  },
  rol: {
    type: String,
    enum: ['Creador', 'Editor', 'Lector'],
    required: false,
    default: 'Lector'
  },
  notificaciones: {
    type: Boolean,
    required: true,
    default: true
  },
  permisos: {
    type: Map,
    of: String,
    required: true,
    default: {
      'Información General': 'Si',
      Agenda: 'Si',
      Usuarios: 'Si',
      'Partes Involucradas': 'Si',
      Notas: 'Si',
      'Gastos e Ingresos': 'Si',
      Documentos: 'Si',
      Historial: 'Si',
      'Recursos e Incidentes': 'Si',
      Pautas: 'Si'
    }
  }
}, {
  versionKey: false
});

ExpedientesUsuarios.index({ despacho: 1, usuario: 1 });
ExpedientesUsuarios.plugin(mongoosePaginate);

module.exports = model('expedientesUsuarios', ExpedientesUsuarios);
