const { Schema, model } = require('mongoose');

const ExpedientesAgendaUsuariosSchema = new Schema({
  despacho: {
    type: Schema.Types.ObjectId,
    ref: 'despachos',
    required: true,
    index: true
  },
  expediente: {
    type: Schema.Types.ObjectId,
    ref: 'expedientes',
    required: false,
    default: null
  },
  usuario: {
    type: Schema.Types.ObjectId,
    ref: 'usuarios',
    required: false
  },
  cliente: {
    type: Schema.Types.ObjectId,
    ref: 'clientes',
    required: false
  },
  invitado: {
    nombre: {
      type: String,
      required: false
    },
    email: {
      type: String,
      required: false
    },
    whatsapp: {
      type: String,
      required: false
    }
  },
  prospecto: {
    type: Schema.Types.ObjectId,
    ref: 'prospectosDespacho',
    required: false
  },
  agenda: {
    type: Schema.Types.ObjectId,
    ref: 'expedientesAgenda',
    required: true
  },
  recordar: {
    type: Number,
    required: false,
    default: 0
  },
  fechaRecordatorio: {
    type: Date,
    required: false,
    default: null,
    index: true
  },
  comentario: {
    type: String,
    required: false,
    default: ''
  },
  estatus: {
    type: String,
    enum: ['Pendiente', 'Cancelada', 'Realizada', 'Aceptada', 'Rechazada'],
    required: true,
    default: 'Pendiente'
  },
  color: {
    type: String,
    required: false
  }
}, {
  versionKey: false
});

module.exports = model('expedientesAgendaUsuarios', ExpedientesAgendaUsuariosSchema);
