const { Schema, model } = require('mongoose');

const ExpedientesAgendaSchema = new Schema({
  despacho: {
    type: Schema.Types.ObjectId,
    ref: 'despachos',
    required: true,
    index: true
  },
  expediente: {
    type: Schema.Types.ObjectId,
    ref: 'expedientes',
    required: false,
    default: null,
    index: true
  },
  title: {
    type: String,
    required: true
  },
  descripcion: {
    type: String,
    required: false,
    default: ''
  },
  fecha: { // fecha inicio evento
    type: Date,
    required: true,
    index: true
  },
  fechaFin: {
    type: Date,
    required: false,
    default: null
  },
  creadoPor: {
    type: Schema.Types.ObjectId,
    ref: 'usuarios',
    required: true
  },
  fechaCreacion: {
    type: Date,
    required: true,
    default: Date.now
  },
  estatus: {
    type: String,
    enum: ['Aceptada', 'Rechazada', 'Pendiente', 'Cancelada', 'Realizada'],
    required: true,
    default: 'Pendiente'
  }
}, {
  versionKey: false
});

module.exports = model('expedientesAgenda', ExpedientesAgendaSchema);
