const { Schema, model } = require("mongoose");
const mongoosePaginate = require("mongoose-paginate-v2");

const ExpedientesSchema = new Schema(
  {
    despacho: {
      type: Schema.Types.ObjectId,
      ref: "despachos",
      required: true,
      index: true,
    },
    procedimiento: {
      type: String,
      enum: ["Litigioso", "No litigioso"],
      required: true,
      index: true,
    },
    numeroExpediente: {
      type: String,
      required: false,
      default: "",
      index: true,
    },
    numeroExpedienteInterno: {
      type: String,
      required: false,
      default: "",
      index: true,
    },
    titulo: {
      type: String,
      required: true,
      index: true,
    },
    fechaInicio: {
      type: Date,
      required: true,
      default: Date.now,
      index: true,
    },
    fechaTermino: {
      type: Date,
      required: false,
    },
    cliente: {
      type: Schema.Types.ObjectId,
      ref: "clientes",
      required: true,
    },
    asunto: {
      type: Schema.Types.ObjectId,
      ref: "asuntos",
      required: true,
    },
    juzgado: {
      nombre: {
        type: String,
        required: false,
        default: "",
      },
      juzgado: {
        type: Schema.Types.ObjectId,
        ref: "juzgados",
        required: false,
        default: null,
        index: true,
      },
    },
    materia: {
      nombre: {
        type: String,
        required: false,
        default: "",
      },
      materia: {
        type: Schema.Types.ObjectId,
        ref: "materiasDespachos",
        required: false,
        index: true,
      },
    },
    municipio: {
      type: String,
      required: false,
      default: "",
    },
    estado: {
      type: String,
      required: false,
      default: "",
    },
    objetivos: {
      type: String,
      required: false,
      default: "",
    },
    etapaProcesal: {
      nombre: {
        type: String,
        required: false,
        default: "",
      },
      etapa: {
        type: Schema.Types.ObjectId,
        ref: "etapasProcesalesDespachos",
        required: false,
      },
    },
    ultimoMovimiento: {
      type: Date,
      required: false,
      default: Date.now,
      index: true,
    },
    ultimoCambio: {
      type: Date,
      required: false,
      default: Date.now,
    },
    creadoPor: {
      type: Schema.Types.ObjectId,
      ref: "usuarios",
      required: true,
    },
    estatus: {
      type: String,
      enum: ["Activo", "Inactivo", "Concluido", "Suspendido"],
      default: "Activo",
      required: true,
      index: true,
    },
  },
  {
    versionKey: false,
  }
);

ExpedientesSchema.index({ despacho: 1, procedimiento: 1 });
ExpedientesSchema.index({ numeroExpediente: 1, numeroExpedienteInterno: 1 });
ExpedientesSchema.index({ titulo: "text" }); // Índice de texto para búsqueda de texto completo en el campo 'titulo'
ExpedientesSchema.index({ fechaInicio: 1, fechaTermino: 1 });
ExpedientesSchema.index({ cliente: 1, asunto: 1 });
ExpedientesSchema.index({ "juzgado.juzgado": 1 });
ExpedientesSchema.index({ "materia.materia": 1 });
ExpedientesSchema.index({ "etapaProcesal.etapa": 1 });
ExpedientesSchema.index({ ultimoMovimiento: 1 });
ExpedientesSchema.index({ creadoPor: 1 });
ExpedientesSchema.index({ estatus: 1 });
ExpedientesSchema.index({ "cliente.nombre": "text" });
ExpedientesSchema.index({ despacho: 1, titulo: 1, numeroExpediente: 1 });
ExpedientesSchema.index({
  titulo: "text",
  numeroExpediente: "text",
  numeroExpedienteInterno: "text",
});

ExpedientesSchema.plugin(mongoosePaginate);
module.exports = model("expedientes", ExpedientesSchema);
