const mongoose = require('mongoose');
const Schema = mongoose.Schema;

// Definir el esquema de la carpeta
const expedienteFolderSchema = new Schema({
  despacho: {
    type: Schema.Types.ObjectId,
    ref: 'Despacho',
    required: true,
    index: true
  },
  expediente: {
    type: Schema.Types.ObjectId,
    ref: 'Expediente',
    required: true,
    index: true
  },
  name: {
    type: String,
    required: true,
    trim: true
  },
  parentFolder: {
    type: Schema.Types.ObjectId,
    ref: 'ExpedienteFolder',
    default: null,
    index: true // Añadir índice aquí
  },
  subfolders: [{
    type: Schema.Types.ObjectId,
    ref: 'ExpedienteFolder'
  }],
  files: [{
    type: Schema.Types.ObjectId,
    ref: 'File'
  }],
  createdAt: {
    type: Date,
    default: Date.now
  }
});

// Crear el modelo de la carpeta
const ExpedienteFolder = mongoose.model('ExpedienteFolder', expedienteFolderSchema);

module.exports = ExpedienteFolder;
