const { Schema, model } = require('mongoose');
const mongoosePaginate = require('mongoose-paginate-v2');

const EtapasProcesalesDespachosSchema = new Schema({
  despacho: {
    type: Schema.Types.ObjectId,
    ref: 'despachos',
    required: true,
    index: true // Index for optimized search
  },
  nombre: {
    type: String,
    required: true,
    index: true // Index for optimized search
  },
  tipo: {
    type: String,
    enum: ['Litigioso', 'No Litigioso'],
    default: 'Litigioso',
    required: true
  },
  materia: {
    type: Schema.Types.ObjectId,
    ref: 'materiasDespachos',
    required: true,
    index: true // Index for optimized search
  },
  estatus: {
    type: String,
    enum: ['Activo', 'Inactivo'],
    default: 'Activo',
    required: true,
    index: true // Index for optimized search
  }
}, {
  versionKey: false
});

EtapasProcesalesDespachosSchema.index({ nombre: 1, despacho: 1, materia: 1, estatus: 1 });

EtapasProcesalesDespachosSchema.plugin(mongoosePaginate);

module.exports = model('etapasProcesalesDespachos', EtapasProcesalesDespachosSchema);
