const { Schema, model } = require('mongoose');
const mongoosePaginate = require('mongoose-paginate-v2');

const DiarioOficialModel = new Schema(
  {
    estado: {
      type: Schema.Types.ObjectId,
      ref: 'estados',
      required: false,
      default: null
    },
    tipo: {
      type: String,
      required: false,
      enum: ['Estatal', 'Federal'],
      default: 'Estatal'
    },
    nombre: {
      type: String,
      required: false,
      default: ''
    },
    url: {
      type: String,
      required: false,
      default: ''
    },
    estatus: {
      type: String,
      enum: ['Activo', 'Inactivo'],
      required: false,
      default: 'Activo'
    }
  },
  {
    versionKey: false
  }
);

DiarioOficialModel.plugin(mongoosePaginate);

module.exports = model('diarioOficial', DiarioOficialModel);
