const { Schema, model } = require('mongoose');
const mongoosePaginate = require('mongoose-paginate-v2');

const DespachosSchema = new Schema({
  distribuidor: {
    type: Schema.Types.ObjectId,
    ref: 'usuarios',
    required: false,
    index: true
  },
  contadorExp: {
    contador: {
      type: Number,
      required: false,
      default: 0
    },
    limite: {
      type: Number,
      required: false,
      default: 0
    },
    vigencia: {
      type: Date,
      required: false,
      default: null
    },
    paquete: {
      type: Schema.Types.ObjectId,
      ref: 'productos',
      required: false
    }
  },
  contadorTimbres: {
    contador: {
      type: Number,
      required: false,
      default: 0
    },
    limite: {
      type: Number,
      required: false,
      default: 0
    },
    vigencia: {
      type: Date,
      required: false,
      default: null
    }
  },
  contadorChatGPT: {
    diario: {
      contador: {
        type: Number,
        required: false,
        default: 0
      },
      limite: {
        type: Number,
        required: false,
        default: 20
      },
      fechaUltimoReinicio: {
        type: Date,
        required: false,
        default: null
      }
    },
    comprado: {
      contador: {
        type: Number,
        required: false,
        default: 0
      },
      limite: {
        type: Number,
        required: false,
        default: 0
      }
    }
  },
  nombre: {
    type: String,
    required: false,
    default: ''
  },
  direccion: {
    type: String,
    required: false,
    default: ''
  },
  creadoPor: {
    type: Schema.Types.ObjectId,
    ref: 'usuarios',
    required: false
  },
  estado: {
    type: Schema.Types.ObjectId,
    ref: 'estados',
    required: false
  },
  municipio: {
    type: Schema.Types.ObjectId,
    ref: 'municipios',
    required: false
  },
  correo: {
    type: String,
    required: true
  },
  telefono: {
    type: String,
    required: false,
    default: ''
  },
  razonSocial: {
    type: String,
    required: false,
    default: ''
  },
  rfc: {
    type: String,
    required: false,
    default: ''
  },
  c_regimenfiscal: {
    type: String,
    required: false,
    default: ''
  },
  lugarExpedicion: {
    type: String,
    required: false,
    default: ''
  },
  logo: {
    type: String,
    required: false,
    default: ''
  },
  serie: {
    type: String,
    required: false,
    default: ''
  },
  numeroCertificado: {
    type: String,
    required: false,
    default: ''
  },
  archivoCer: {
    type: String,
    required: false,
    default: ''
  },
  archivoKey: {
    type: String,
    required: false,
    default: ''
  },
  clavePrivada: {
    type: String,
    required: false,
    default: ''
  },
  archivoCerPem: {
    type: String,
    required: false,
    default: ''
  },
  archivoKeyPem: {
    type: String,
    required: false,
    default: ''
  },
  estatus: {
    type: String,
    enum: ['Activo', 'Inactivo'],
    required: true,
    default: 'Activo',
    index: true
  },
  fechaCreacion: {
    type: Date,
    default: new Date(),
    required: true
  }

}, {
  versionKey: false
});

DespachosSchema.plugin(mongoosePaginate);
module.exports = model('despachos', DespachosSchema);
