const { Schema, model } = require('mongoose');
const mongoosePaginate = require('mongoose-paginate-v2');

const cuentaBancariaSchema = new Schema({
  usuario: {
    type: Schema.Types.ObjectId,
    ref: 'usuarios',
    required: true
  },
  tipo: {
    type: String,
    required: true,
    enum: ['Clabe', 'Débito']
  },
  banco: { // cuando es tarjeta
    type: Schema.Types.ObjectId,
    ref: 'bancos',
    required: false,
    default: null
  },
  numero: {
    type: String,
    required: true
  },
  titular: {
    type: String,
    required: true
  }

}, {
  versionKey: false
});

cuentaBancariaSchema.plugin(mongoosePaginate);

module.exports = model('cuentaBancariaDistribuidor', cuentaBancariaSchema);
