const { Schema, model } = require('mongoose');
const mongoosePaginate = require('mongoose-paginate-v2');

const CortesDistribuidoresSchema = new Schema({
  distribuidor: {
    type: Schema.Types.ObjectId,
    ref: 'usuarios',
    required: true
  },
  fecha: {
    inicio: {
      type: Date,
      required: true
    },
    fin: {
      type: Date,
      required: true
    },
    corte: {
      type: Date,
      required: true
    }
  },
  totalVentas: {
    type: Number,
    required: true
  },
  importePago: { // total a pagar
    type: Number,
    required: true
  },
  importeSinComision: {
    type: Number,
    required: false
  },
  ventas: [{
    type: Schema.Types.ObjectId,
    ref: 'ventas',
    required: true
  }],
  comprobante: {
    factura: { // del distribuidor
      type: String,
      required: false,
      default: null
    },
    xml: {
      type: String,
      required: false,
      default: null
    },
    pago: { // de psd
      type: String,
      required: false,
      default: null
    },
    fechaPago: {
      type: Date,
      required: false,
      default: null
    }
  },
  estatus: {
    type: String,
    required: true,
    enum: ['Pendiente', 'Pagado', 'Cancelado', 'Pendiente de revisión']
  },
  observaciones: {
    type: String,
    required: false,
    default: null
  }
}, {
  versionKey: false
});

CortesDistribuidoresSchema.plugin(mongoosePaginate);

module.exports = model('corteDistribuidores', CortesDistribuidoresSchema);
