const { Schema, model } = require('mongoose');
const mongoosePaginate = require('mongoose-paginate-v2');

const CopyUsuarioSchema = new Schema({
  usuario: {
    type: Schema.Types.ObjectId,
    ref: 'usuarios',
    required: true
  },
  nombre: {
    type: String,
    required: true,
    trim: true
  },
  copy: {
    type: String,
    required: true,
    trim: true
  },
  type: {
    type: String,
    enum: ['WhatsApp', 'Correo'],
    required: true,
    index: true
  },
  dirigido: {
    type: String,
    enum: ['Despachos', 'Distribuidor'],
    required: true,
    index: true
  },
  estatus: {
    type: String,
    enum: ['Activo', 'Inactivo'],
    default: 'Activo'
  }
}, {
  versionKey: false
});

CopyUsuarioSchema.plugin(mongoosePaginate);

module.exports = model('copyUsuario', CopyUsuarioSchema);
