const { Schema, model } = require('mongoose');
const mongoosePaginate = require('mongoose-paginate-v2');

const CopyPsdSchema = new Schema({
  nombre: {
    type: String,
    required: true,
    trim: true
  },
  copy: {
    type: String,
    required: true,
    trim: true
  },
  type: {
    type: String,
    enum: ['WhatsApp', 'Correo'],
    required: true,
    index: true
  },
  dirigido: {
    type: String,
    enum: ['Despachos', 'Distribuidor'],
    required: true,
    index: true
  },
  estatus: {
    type: String,
    enum: ['Activo', 'Inactivo'],
    default: 'Activo'
  }
}, {
  versionKey: false
});

CopyPsdSchema.plugin(mongoosePaginate);

module.exports = model('copypsds', CopyPsdSchema);
