const { Schema, model } = require("mongoose");
const mongoosePaginate = require("mongoose-paginate-v2");

const ContadorProspecto = new Schema(
  {
    prospecto: {
      type: Schema.Types.ObjectId,
      ref: "usuarios",
      required: true,
      index: true,
    },
    distribuidor: {
      type: Schema.Types.ObjectId,
      ref: "usuarios",
      required: true,
      index: true,
    },
    tipo: {
      type: String,
      enum: ["WhatsApp", "Correo"],
      required: true,
    },
    contador: {
      type: Number,
      default: 0,
      required: true,
    },
    ultimoContacto: {
      type: Date,
      required: true,
    },
  },
  {
    versionKey: false,
  }
);

ContadorProspecto.plugin(mongoosePaginate);
module.exports = model("contadorProspecto", ContadorProspecto);
