const { Schema, model } = require('mongoose');

const ConfiguracionesSchema = new Schema({
  razonSocial: {
    type: String,
    required: false
  },
  rfc: {
    type: String,
    required: false
  },
  regimenFiscal: {
    type: String,
    required: false
  },
  direccion: {
    type: String,
    required: false
  },
  lugarExpedicion: {
    type: String,
    required: false
  },
  logo: {
    type: String,
    required: false
  },
  serie: {
    type: String,
    required: false
  },
  numeroCertificado: {
    type: String,
    required: false
  },
  archivoKey: {
    type: String,
    required: false
  },
  clavePrivada: {
    type: String,
    required: false
  },
  archivoCerPem: {
    type: String,
    required: false
  },
  archivoKeyPem: {
    type: String,
    required: false
  },
  payPal: {
    clientID: {
      type: String,
      required: false
    },
    clientSecret: {
      type: String,
      required: false
    },
    tipo: {
      type: String,
      enum: ['Live', 'Sandbox'],
      required: false
    }
  },
  stripe: {
    publishableKey: {
      type: String,
      required: false
    },
    secretKey: {
      type: String,
      required: false
    }

  },
  limiteDiarioGPT: {
    type: Number,
    default: 25
  }
}, {
  versionKey: false
});

module.exports = model('configuraciones', ConfiguracionesSchema);
