// models/Chat.js
const mongoose = require('mongoose');
const { Schema } = mongoose;
const mongoosePaginate = require('mongoose-paginate-v2');

const chatV2Schema = new mongoose.Schema({
  role: {
    type: String,
    enum: ['user', 'assistant'],
    required: true
  },
  content: {
    type: String,
    required: true
  },
  timestamp: {
    type: Date,
    default: Date.now
  },
  usuario: {
    type: Schema.Types.ObjectId,
    ref: 'usuarios',
    required: false,
    default: null
  },
  despacho: {
    type: Schema.Types.ObjectId,
    ref: 'despachos',
    required: true
  },
  estatus: {
    type: String,
    enum: ['Activo', 'Inactivo'],
    required: true,
    default: 'Activo'
  }
});

chatV2Schema.plugin(mongoosePaginate);

const Chat = mongoose.model('ChatV2', chatV2Schema);

module.exports = Chat;
