// models/Chat.js
const mongoose = require('mongoose');
const { Schema } = mongoose;

const chatSchema = new mongoose.Schema({
  conversationId: { type: String, required: true },
  messages: [
    {
      role: {
        type: String,
        enum: ['user', 'assistant'],
        required: true
      },
      content: {
        type: String,
        required: true
      },
      timestamp: {
        type: Date,
        default: Date.now
      },
      usuario: {
        type: Schema.Types.ObjectId,
        ref: 'usuarios',
        required: false,
        default: null
      }
    }
  ],
  despacho: {
    type: Schema.Types.ObjectId,
    ref: 'despachos',
    required: true
  },
  favorito: {
    type: Schema.Types.ObjectId,
    ref: 'BusquedaFavoritos',
    required: false,
    default: null
  }
});

const Chat = mongoose.model('Chat', chatSchema);

module.exports = Chat;
