const { Schema, model } = require('mongoose');
const mongoosePaginate = require('mongoose-paginate-v2');
const { buildFileUri } = require('../config/s3.js');
const { formatDate } = require('../config/functionsGlobal.js');

const TesisFavoritosSchema = new Schema(
  {
    despacho: {
      type: Schema.Types.ObjectId,
      ref: 'despachos',
      required: false,
      index: true
    },
    id: {
      type: String,
      required: true
    },
    nombre: {
      type: String,
      required: true,
      trim: true,
      index: true
    },
    tipo: {
      type: String,
      enum: [
        'Tesis',
        'Votos',
        'Precedente',
        'Jurisprudencia Corte IDH',
        'Diario Oficial',
        'Chat GPT'
      ],
      required: true
    },
    texto: {
      type: String,
      required: false,
      trim: true
    },
    epoca: {
      type: String,
      required: false,
      trim: true
    },
    fechaCreacion: {
      type: Date,
      required: true,
      default: Date.now
    },
    creadoPor: {
      type: Schema.Types.ObjectId,
      ref: 'usuarios',
      required: true
    }
  },
  {
    versionKey: false
  }
);

TesisFavoritosSchema.methods.toJSON = function () {
  const obj = this.toObject();

  obj.fechaCreacion = formatDate(obj.fechaCreacion);

  if (obj.creadoPor && obj.creadoPor.foto) {
    obj.creadoPor.foto = buildFileUri(
      `despachos/${obj.despacho}/usuarios/${obj.creadoPor.foto}`
    );
  } else {
    obj.creadoPor.foto = buildFileUri('default/icono_usuario_100x100_04.jpg');
  }

  return obj;
};

TesisFavoritosSchema.plugin(mongoosePaginate);
module.exports = model('BusquedaFavoritos', TesisFavoritosSchema);
