const { Schema, model } = require('mongoose');
const mongoosePaginate = require('mongoose-paginate-v2');
const moment = require('moment');
const AlertasSchema = new Schema({
  despacho: {
    type: Schema.Types.ObjectId,
    ref: 'despachos',
    required: true,
    index: true
  },
  creadoPor: {
    type: Schema.Types.ObjectId,
    ref: 'usuarios',
    required: true
  },
  dirigidos: [{
    estatus: {
      type: String,
      required: true,
      enum: ['Pendiente', 'Atendido']
    },
    usuarios: {
      type: Schema.Types.ObjectId,
      ref: 'usuarios',
      required: true
    },
    comentario: {
      type: String,
      required: false
    }
  }],
  titulo: {
    type: String,
    required: true
  },
  mensaje: {
    type: String,
    required: false,
    default: ''
  },
  fecha: {
    type: Date,
    required: true,
    default: Date.now
  },
  color: {
    type: String,
    required: true
  }
}, {
  versionKey: false
});

AlertasSchema.plugin(mongoosePaginate);

AlertasSchema.methods.toJSON = function () {
  const alert = this.toObject();
  alert.fecha = moment(alert.fecha).format('DD/MM/YYYY hh:mm a');
  return alert;
};

module.exports = model('alertas', AlertasSchema);
