/* eslint-disable camelcase */
const VentasModel = require("../models/Ventas.js");
const ProductosModel = require("../models/Productos.js");
const UsuariosModel = require("../models/Usuarios.js");
const DespachosModel = require("../models/Despachos.js");
const moment = require("moment-timezone");
const { sendWhatsappMovimiento } = require("../config/functionsGlobal.js");
const { sendMail } = require("../config/mail.js");
const { CompraHTML } = require("../Mail/CompraHTML.js");
const { buildFileUri } = require("../config/s3.js");
const Usuarios = require("../models/Usuarios.js");

const createVenta = async (req, res) => {
  const {
    producto,
    usuario,
    despacho = null,
    tipoReferencia,
    referencia,
    tipo = "",
  } = req.body;

  if (!producto) {
    return res.status(400).json({ message: "Producto es requerido" });
  }

  if (!usuario) {
    return res.status(400).json({ message: "Usuario es requerido" });
  }

  try {
    const findVenta = await VentasModel.findOne({
      producto,
      usuario,
      despacho,
      tipoReferencia,
      referencia,
    });

    if (findVenta) {
      return res.status(400).json({ message: "Venta ya registrada" });
    }

    let findDespacho = null;

    if (despacho) {
      findDespacho = await DespachosModel.findById(despacho);

      if (!findDespacho) {
        return res.status(400).json({ message: "Despacho no encontrado" });
      }
    }

    const findUsuario = await UsuariosModel.findById(usuario);

    if (!findUsuario) {
      return res.status(400).json({ message: "Usuario no encontrado" });
    }

    const findProducto = await ProductosModel.findById(producto);

    if (!findProducto) {
      return res.status(400).json({ message: "Producto no encontrado" });
    }

    const {
      _id,
      nombre,
      precio,
      tiempo,
      pruebaGratis,
      tipo_producto,
      cantidad,
      utilidad,
    } = findProducto;

    const fechaMexico = moment()
      .tz("America/Mexico_City")
      .format("YYYY-MM-DD HH:mm:ss");

    // Lógica para diferentes tipos de productos
    if (tipo_producto === "Paquete" && findDespacho) {
      const fehcaVencimientoViejo = moment(
        findDespacho.contadorExp.vigencia
      ).format("YYYY-MM-DD HH:mm:ss");

      let fechaVencimientoNuevo;

      if (moment(fehcaVencimientoViejo).isAfter(fechaMexico)) {
        fechaVencimientoNuevo = moment(fehcaVencimientoViejo)
          .add(tiempo, "days")
          .format("YYYY-MM-DD HH:mm:ss");
      } else {
        fechaVencimientoNuevo = moment(fechaMexico)
          .add(tiempo, "days")
          .format("YYYY-MM-DD HH:mm:ss");
      }

      findDespacho.contadorExp.limite = cantidad;
      findDespacho.contadorExp.paquete = findProducto._id;
      findDespacho.contadorExp.vigencia = fechaVencimientoNuevo;

      await findDespacho.save();

      sendWhatsappMovimiento({
        to: findUsuario.telefono,
        var1: "Hemos recibido tu pago de " + nombre,
        var2: "Tu paquete se ha activado",
        var3:
          "Vigencia: " +
          moment(findDespacho.contadorExp.vigencia).format("DD/MM/YYYY"),
        url: "?",
      });

      const html = CompraHTML({
        nombre: findUsuario.nombre,
        nombreProducto: nombre,
        precioProducto: precio,
        descripcionProducto: findProducto.descripcion,
      });

      sendMail(html, "Compra de Paquete", findUsuario.email);
    }

    if (tipo_producto === "GPT-4" && findDespacho) {
      findDespacho.contadorChatGPT.comprado.limite += cantidad;

      await findDespacho.save();

      sendWhatsappMovimiento({
        to: findUsuario.telefono,
        var1: "Hemos recibido tu pago de " + nombre,
        var2: "Tu paquete se ha activado",
        var3: " ",
        url: "?",
      });

      const html = CompraHTML({
        nombre: findUsuario.nombre,
        nombreProducto: nombre,
        precioProducto: precio,
        descripcionProducto: findProducto.descripcion,
      });

      sendMail(html, "Compra de GPT-4", findUsuario.email);
    }

    if (tipo_producto === "Plantilla") {
      const urlFile = buildFileUri(`productos/${findProducto.archivo}`);

      const html = CompraHTML({
        nombre: findUsuario.nombre,
        nombreProducto: nombre,
        precioProducto: precio,
        descripcionProducto: findProducto.descripcion,
      });

      await sendMail(html, "Compra de Plantilla", findUsuario.email, [
        {
          filename: findProducto.archivo,
          path: urlFile,
        },
      ]);

      await sendWhatsappMovimiento({
        to: findUsuario.telefono.toString().trim(),
        var1: "Hemos recibido tu pago de " + nombre,
        var2: " ",
        var3: " ",
        url: `?file=${findProducto.archivo}`,
      });
    }

    if (tipo_producto === "Timbres" && findDespacho) {
      findDespacho.contadorTimbres.limite += cantidad;

      if (moment(findDespacho.contadorTimbres.vigencia).isAfter(fechaMexico)) {
        findDespacho.contadorTimbres.vigencia = moment(
          findDespacho.contadorTimbres.vigencia
        )
          .add(tiempo, "days")
          .format("YYYY-MM-DD HH:mm:ss");
      } else {
        findDespacho.contadorTimbres.vigencia = moment(fechaMexico)
          .add(tiempo, "days")
          .format("YYYY-MM-DD HH:mm:ss");
      }

      await findDespacho.save();

      sendWhatsappMovimiento({
        to: findUsuario.telefono,
        var1: "Hemos recibido tu pago de " + nombre,
        var2: "Tu paquete se ha activado",
        var3:
          "Vigencia: " +
          moment(findDespacho.contadorTimbres.vigencia).format("DD/MM/YYYY"),
        url: "?",
      });

      const html = CompraHTML({
        nombre: findUsuario.nombre,
        nombreProducto: nombre,
        precioProducto: precio,
        descripcionProducto: findProducto.descripcion,
      });

      sendMail(html, "Compra de Timbres", findUsuario.email);
    }

    let distribuidor;
    let promotor = null;
    let vendedor = null;

    if (
      findDespacho &&
      findDespacho?.distribuidor &&
      tipo_producto === "Paquete"
    ) {
      console.log("Entro 1");

      const findDistribuidor = await UsuariosModel.findById(
        findDespacho.distribuidor
      )
        .populate({
          path: "licencia.referidoPor",
          select: "licencia tipoUsuarios",
        })
        .select("licencia tipoUsuarios");

      if (findDistribuidor) {
        const { licencia } = findDistribuidor;
        const licenciaPadre =
          findDistribuidor?.licencia?.referidoPor?.licencia || null;

        const tipoPadre =
          findDistribuidor?.licencia?.referidoPor?.tipoUsuarios || null;

        if (licencia) {
          const { vigencia } = licencia;

          if (moment(vigencia).isAfter(fechaMexico)) {
            if (findDistribuidor.tipoUsuarios.promotor) {
              promotor = {
                comision: licencia.comision,
                promotor: findDistribuidor._id,
                importe: (precio * licencia.comision) / 100,
              };
              distribuidor = {
                comision: licenciaPadre.comision,
                distribuidor: findDistribuidor.licencia.referidoPor,
                importe: (precio * licenciaPadre.comision) / 100,
              };
            } else if (findDistribuidor.tipoUsuarios.vendedor) {
              if (tipoPadre.distribuidor) {
                distribuidor = {
                  comision: licenciaPadre.comision,
                  distribuidor: findDistribuidor.licencia.referidoPor,
                  importe: (precio * licenciaPadre.comision) / 100,
                };
                vendedor = {
                  comision: licencia.comision,
                  vendedor: findDistribuidor._id,
                  importe: (precio * licencia.comision) / 100,
                };
              }
              if (tipoPadre.promotor) {
                const datosDistribuidor = await Usuarios.findById(
                  findDistribuidor?.licencia?.referidoPor?.licencia?.referidoPor
                ).select("licencia");

                distribuidor = {
                  comision: datosDistribuidor.licencia.comision,
                  distribuidor: datosDistribuidor._id,
                  importe: (precio * datosDistribuidor.licencia.comision) / 100,
                };
                promotor = {
                  comision: licenciaPadre.comision,
                  promotor: findDistribuidor.licencia.referidoPor,
                  importe: (precio * licenciaPadre.comision) / 100,
                };
                vendedor = {
                  comision: licencia.comision,
                  vendedor: findDistribuidor._id,
                  importe: (precio * licencia.comision) / 100,
                };
              }
            } else {
              distribuidor = {
                comision: licencia.comision,
                distribuidor: findDistribuidor._id,
                importe: (precio * licencia.comision) / 100,
              };
            }
          }
        }
      }
    }

    if (tipo === "Licencia") {
      console.log("Entro 2");
      const vigencia = moment().add(cantidad, "years").toDate();

      const obj = {
        "licencia.producto": _id,
        "licencia.comision": utilidad,
        "licencia.vigencia": vigencia,
      };

      await Usuarios.findByIdAndUpdate(findUsuario._id, obj, { new: true });

      const findDistribuidor = await UsuariosModel.findById(
        findUsuario.licencia.referidoPor
      ).select("licencia");

      if (findDistribuidor) {
        const { licencia } = findDistribuidor;

        if (licencia) {
          const { vigencia } = licencia;

          if (moment(vigencia).isAfter(fechaMexico)) {
            distribuidor = {
              comision: licencia.comision,
              distribuidor: findDistribuidor._id,
              importe: (precio * licencia.comision) / 100,
            };
          }
        }
      }

      sendWhatsappMovimiento({
        to: findUsuario.telefono,
        var1: "Hemos recibido tu pago de " + `Licencia ${findProducto.nombre}`,
        var2: "Tu paquete se ha activado",
        var3: "Vigencia: " + moment(vigencia).format("DD/MM/YYYY"),
        url: "?",
      });

      const html = CompraHTML({
        nombre: findUsuario.nombre,
        nombreProducto: `Licencia ${findProducto.nombre}`,
        precioProducto: precio,
        descripcionProducto: findProducto.descripcion,
      });

      sendMail(html, "Compra de Licencia", findUsuario.email);
    }

    const newVenta = new VentasModel({
      despacho: findDespacho ? findDespacho._id : null,
      usuario: findUsuario._id,
      producto: _id,
      importe: pruebaGratis ? 0 : precio,
      tipoReferencia,
      referencia,
      estatus: "Pagado",
      who: findDespacho?.distribuidor || null,
      promotor,
      vendedor,
      distribuidor:
        tipo_producto === "Licencia" || tipo_producto === "Paquete"
          ? distribuidor
          : {
              comision: 0,
              distribuidor: null,
              importe: 0,
            },
    });

    await newVenta.save();

    res.status(200).json({
      message: "Venta creada",
      venta: newVenta,
      despacho: findDespacho,
      usuario: findUsuario,
      producto: findProducto,
    });
  } catch (error) {
    res.status(400).json({ message: error.message });
  }
};

module.exports = {
  createVenta,
};
