const ConfiguracionesModel = require('../models/Configuraciones.js');
// Configuración de ambiente (puede ser sandbox o live)

const getPaymentDetails = async (req, res) => {
  const { transactionId } = req.params;

  if (!transactionId) {
    return res.status(400).json({ message: 'transactionId es requerido' });
  }

  try {
    const findConfiguraciones = await ConfiguracionesModel.findOne();

    if (!findConfiguraciones) {
      return res.status(400).json({ message: 'No se ha configurado la información de stripe' });
    }

    const { stripe: stripeCredenciales } = findConfiguraciones;

    if (!stripeCredenciales) {
      return res.status(400).json({ message: 'No se ha configurado la información de stripe' });
    }

    const { secretKey } = stripeCredenciales;

    const stripe = require('stripe')(secretKey);

    const paymentIntent = await stripe.paymentIntents.retrieve(transactionId);

    return res.status(200).json({
      payment: paymentIntent
    });
  } catch (error) {
    console.error(error);
    return res.status(500).json({ message: 'Error al obtener los detalles del pago', error });
  }
};

module.exports = {
  getPaymentDetails
};
