const paypal = require('@paypal/checkout-server-sdk');
const ConfiguracionesModel = require('../models/Configuraciones.js');
// Configuración de ambiente (puede ser sandbox o live)

const getPaymentDetails = async (req, res) => {
  const { transactionId } = req.params;

  if (!transactionId) {
    return res.status(400).json({ message: 'transactionId es requerido' });
  }

  const findConfiguraciones = await ConfiguracionesModel.findOne();

  if (!findConfiguraciones) {
    return res.status(400).json({ message: 'No se ha configurado la información de PayPal' });
  }

  const { payPal } = findConfiguraciones;

  if (!payPal) {
    return res.status(400).json({ message: 'No se ha configurado la información de PayPal' });
  }

  const { clientID, clientSecret, tipo } = payPal;

  console.log(tipo);

  let environment = null;
  if (tipo === 'Sandbox') {
    environment = new paypal.core.SandboxEnvironment(clientID, clientSecret);
  }

  if (tipo === 'Live') {
    environment = new paypal.core.LiveEnvironment(clientID, clientSecret);
  }

  if (!environment) {
    return res.status(400).json({ message: 'Tipo de ambiente no válido' });
  }

  const client = new paypal.core.PayPalHttpClient(environment);

  const request = new paypal.orders.OrdersGetRequest(transactionId);

  try {
    const response = await client.execute(request);
    return res.status(200).json({
      payment: response.result
    });
  } catch (error) {
    console.error(error);
    return res.status(500).json({ message: 'Error al obtener los detalles del pago', error });
  }
};

module.exports = {
  getPaymentDetails
};
