const usuarioModel = require('../models/Usuarios.js');
const TourModel = require('../models/Tour.js'); // Importa el modelo de tours si no estás usando el lookup

const TourGetSinPaginar = async (req, res) => {
  const { usuarioId } = req.params;

  try {
    // Obtén el usuario
    const usuario = await usuarioModel.findById(usuarioId);

    // Si el usuario no existe
    if (!usuario) {
      return res.status(404).json([]);
    }

    // Si el usuario ya completó el tour
    if (usuario.tour) {
      return res.json([]);
    }

    // Obtén los tours activos
    const tours = await TourModel.find({ estatus: 'Activo' });

    // Muestra los tours o un array vacío si no hay tours
    res.json(tours);
  } catch (error) {
    res.status(500).json({ message: error.message });
  }
};

const TourCompletar = async (req, res) => {
  const { usuarioId } = req.params;

  try {
    // Actualiza el tour del usuario
    await usuarioModel.findByIdAndUpdate(usuarioId, { tour: true });

    // Muestra un mensaje de éxito
    res.json({ message: 'Tour completado' });
  } catch (error) {
    res.status(500).json({ message: error.message });
  }
};

const TourReset = async (req, res) => {
  const { usuarioId } = req.params;

  try {
    // Actualiza el tour del usuario
    await usuarioModel.findByIdAndUpdate(usuarioId, { tour: false });

    // Muestra un mensaje de éxito
    res.json({ message: 'Tour reseteado' });
  } catch (error) {
    res.status(500).json({ message: error.message });
  }
};

module.exports = {
  TourGetSinPaginar,
  TourCompletar,
  TourReset
};
