const TipoUsuarios = require('../models/TipoUsuarios.js');
const modulos = require('../models/Modulos.js');
const { buildFileUri } = require('../config/s3.js');
// const Modulos = require('../models/Modulos.js');
const getTipoUsuarios = async (req, res) => {
  const { despacho } = req.params;
  const { page = 1 } = req.query;

  const options = {
    page,
    limit: 20,
    populate: 'modulos.modulo'
  };

  if (!despacho) {
    return res.status(400).json({ message: 'El despacho es requerido' });
  }

  const query = {
    despacho
  };

  try {
    const findTipoUsuarios = await TipoUsuarios.paginate(query, options);

    findTipoUsuarios.docs.forEach(tipoUsuario => {
      tipoUsuario.modulos.forEach(modulo => {
        if (modulo?.modulo?.imagen == null || modulo?.modulo?.imagen === undefined) {
          // eslint-disable-next-line no-self-assign
          modulo.modulo.imagen = modulo.modulo.imagen;
        } else {
          if (modulo?.modulo?.imagen?.includes('http')) {
            // eslint-disable-next-line no-self-assign
            modulo.modulo.imagen = modulo.modulo.imagen;
          } else {
            // modulo.modulo.imagen = `${APP_URL}/uploads/modules/white/${modulo.modulo.imagen}`;
            modulo.modulo.imagen = buildFileUri(`modulos/${modulo.modulo.imagen}`);
          }
        }
      });
    });

    const modulos = findTipoUsuarios.docs.map(tipoUsuario => {
      const padres = tipoUsuario.modulos.filter(modulo => modulo.modulo.padre === '');

      return {
        ...tipoUsuario.toObject(),
        modulos: padres.map(modulo => {
          return {
            permisos: modulo.permisos,
            modulo: {
              ...modulo.modulo._doc,
              child: tipoUsuario.modulos.filter(child => child.modulo.padre === modulo.modulo.enlace)
            }
          };
        })
      };
    });

    findTipoUsuarios.docs = modulos;

    res.status(200).json({ tipoUsuarios: findTipoUsuarios });
  } catch (error) {
    console.log('error', error);
    res.status(404).json({ message: error.message });
  }
};

const getTipoUsuarioById = async (req, res) => {
  const { _id } = req.params;
  try {
    const tipoUsuario = await TipoUsuarios.findById(_id).populate({
      path: 'modulos.modulo'
    });

    if (!tipoUsuario) return res.status(404).json({ message: 'No se encontró el tipo de usuario' });

    // Encuentra todos los módulos activos de tipo 'despacho'
    const findModulos = await modulos.find({ estatus: 'Activo', tipo: 'despacho' }).sort({ padre: 1, orden: 1 });

    // Filtra los módulos asignados que también están activos
    const modulosAsignados = tipoUsuario.modulos.filter(modulo => modulo.modulo.estatus === 'Activo').map(modulo => modulo.modulo._id.toString());

    // Encuentra los módulos no asignados que están activos
    const modulosNoAsignados = findModulos.filter(modulo => !modulosAsignados.includes(modulo._id.toString()));

    // Combina los módulos asignados y los no asignados
    const modulosYModulosNoAsignados = [
      ...tipoUsuario.modulos.filter(modulo => modulo.modulo.estatus === 'Activo').map(modulo => ({
        permisos: modulo.permisos,
        modulo: {
          ...modulo.modulo._doc,
          child: []
        }
      })),
      ...modulosNoAsignados.map(modulo => ({
        permisos: {
          create: false,
          read: false,
          update: false,
          delete: false,
          download: false
        },
        modulo: {
          ...modulo._doc,
          child: []
        }
      }))
    ];

    // Reemplaza los módulos en tipoUsuario con la nueva combinación
    tipoUsuario.modulos = modulosYModulosNoAsignados;

    // Filtra los módulos que no tienen padre
    const padres = tipoUsuario.modulos.filter(modulo => !modulo.modulo.padre);

    // Construye la estructura final con los módulos padres y sus hijos
    const modulosNew = padres.map(padre => {
      const hijos = tipoUsuario.modulos.filter(child => child.modulo.padre === padre.modulo.enlace).map(child => ({
        permisos: child.permisos,
        modulo: {
          ...child.modulo._doc
        }
      }));

      return {
        permisos: padre.permisos,
        modulo: {
          ...padre.modulo._doc,
          child: hijos
        }
      };
    });

    // Construye la respuesta final
    const tipoUsuarioNew = {
      _id: tipoUsuario._id,
      nombre: tipoUsuario.nombre,
      modulos: modulosNew
    };

    res.status(200).json({ tipoUsuario: tipoUsuarioNew });
  } catch (error) {
    res.status(404).json({ message: error.message });
  }
};

module.exports = {
  getTipoUsuarios,
  getTipoUsuarioById
};
