const TipoUsuarioModel = require('../models/TipoUsuarios.js');
const ModulosModel = require('../models/Modulos.js');
const UsuarioModal = require('../models/Usuarios.js');
const getTipoUsuarios = async (req, res) => {
  const { despacho } = req.params;
  const query = {
    despacho
  };

  try {
    const tipoUsuarios = await TipoUsuarioModel.find(query);

    const tipoUsuariosFiltrados = tipoUsuarios.map(tipoUsuario => {
      return {
        value: tipoUsuario._id,
        nombre: tipoUsuario.nombre,
        label: tipoUsuario.nombre,
        key: tipoUsuario._id
      };
    });

    res.status(200).json(tipoUsuariosFiltrados);
  } catch (error) {
    res.status(404).json({ message: error.message });
  }
};
const getTipoUsuariosPSD = async (req, res) => {
  const query = {
    tipo: 'admin'
  };

  try {
    const tipoUsuarios = await TipoUsuarioModel.find(query);

    const tipoUsuariosFiltrados = tipoUsuarios.map(tipoUsuario => {
      return {
        value: tipoUsuario._id,
        nombre: tipoUsuario.nombre,
        label: tipoUsuario.nombre,
        key: tipoUsuario._id
      };
    });

    res.status(200).json(tipoUsuariosFiltrados);
  } catch (error) {
    res.status(404).json({ message: error.message });
  }
};

const updateTipoUsuario = async (req, res) => {
  const { _id } = req.params;
  const { nombre, modulos } = req.body;

  const data = {
    nombre,
    modulos
  };

  try {
    const findTipoUsuario = await TipoUsuarioModel.findById(_id);

    if (!findTipoUsuario) {
      return res.status(404).json({ message: 'Tipo de usuario no encontrado' });
    }

    await TipoUsuarioModel.findByIdAndUpdate(_id, data);

    res.status(200).json({ message: 'Tipo de usuario actualizado correctamente' });
  } catch (error) {
    res.status(404).json({ message: error.message });
  }
};

const getModulos = async (req, res) => {
  const { tipo } = req.query;
  try {
    const query = {
      estatus: 'Activo'
    };

    if (tipo) {
      query.tipo = tipo;
    }

    console.log(query);
    const findModulos = await ModulosModel.find(query).sort({ padre: 1, orden: 1 });

    const padres = findModulos.filter(modulo => modulo.padre === '');

    const modulos = padres.map(padre => {
      const hijos = findModulos.filter(modulo => modulo.padre === padre.enlace);
      return {

        ...padre._doc,
        child: hijos
      };
    });

    res.status(200).json(modulos);
  } catch (error) {
    res.status(404).json({ message: error.message });
  }
};

const createTipoUsuario = async (req, res) => {
  const { nombre, modulos, tipo, despacho } = req.body;

  const data = {
    nombre,
    modulos,
    tipo
  };

  if (despacho) {
    data.despacho = despacho;
  }

  try {
    const newTipoUsuario = await TipoUsuarioModel(data);
    const saveTipoUsuario = await newTipoUsuario.save();

    res.status(201).json({ message: 'Tipo de usuario creado correctamente', tipoUsuario: saveTipoUsuario });
  } catch (error) {
    res.status(404).json({ message: error.message });
  }
};

const deleteTipoUsuario = async (req, res) => {
  const { _id } = req.params;

  try {
    const findTipoUsuario = await TipoUsuarioModel.findById(_id);

    if (!findTipoUsuario) {
      return res.status(404).json({ message: 'Tipo de usuario no encontrado' });
    }

    const findUsuariosTipoUsaurioCount = await UsuarioModal.countDocuments({ 'tipoUsuarios.despacho': _id });

    if (findUsuariosTipoUsaurioCount > 0) {
      return res.status(404).json({ message: 'No se puede eliminar el tipo de usuario, ya que tiene usuarios asignados' });
    }

    await TipoUsuarioModel.findByIdAndDelete(_id);

    res.status(200).json({ message: 'Tipo de usuario eliminado correctamente' });
  } catch (error) {
    res.status(404).json({ message: error.message });
  }
};

module.exports = {
  getTipoUsuarios,
  updateTipoUsuario,
  getModulos,
  createTipoUsuario,
  deleteTipoUsuario,
  getTipoUsuariosPSD
};
