const TesisTipo = require('../models/TesisTipo');

const getTiposTesis = async (req, res) => {
  try {
    const tipos = await TesisTipo.find().sort({ order: 1 });

    const tiposTesis = tipos.map((e) => {
      return {
        value: e.value,
        text: e.name,
        label: e.label,
        checked: e.checked,
        key: e._id
      };
    });

    return res.status(200).json(tiposTesis);
  } catch (error) {
    return res.status(500).json({
      mensaje: 'Error al obtener los productos',
      error
    });
  }
};

module.exports = {
  getTiposTesis
};
