const ConfiguracionesModel = require('../models/Configuraciones.js');
const ProductoModel = require('../models/Productos.js');

const createIntent = async (req, res) => {
  const { producto } = req.body;

  if (!producto) {
    return res.status(400).send({ message: 'Falta el producto' });
  }

  try {
    const findConfig = await ConfiguracionesModel.findOne({});

    if (!findConfig) {
      return res.status(404).send({ message: 'Configuraciones no encontradas' });
    }

    const { stripe } = findConfig;

    const { secretKey } = stripe;

    const findProducto = await ProductoModel.findById(producto);

    if (!findProducto) {
      return res.status(404).send({ message: 'Producto no encontrado' });
    }

    const { precio, _id, nombre, imagen, descripcion, tipo_producto: tipoProducto } = findProducto;

    const newStripe = require('stripe')(secretKey);

    const paymentIntent = await newStripe.paymentIntents.create({
      amount: precio * 100,
      currency: 'mxn',
      // payment_method_types: ['card'],
      metadata: {
        _id: _id.toString(),
        producto: _id.toString(),
        nombre,
        imagen,
        descripcion,
        tipoProducto
      }
    });

    res.status(200).send(paymentIntent);
  } catch (error) {
    res.status(500).send({ message: error.message });
  }
};

module.exports = {
  createIntent
};
