const QueryField = require('../models/Queryfield');

const getQueryFields = async (req, res) => {
  try {
    const queryFields = await QueryField.find().sort({ order: 1 });

    const querys = queryFields.map((e) => {
      return {
        value: e.value,
        text: e.name,
        label: e.name,
        checked: e.checked,
        key: e._id
      };
    });

    return res.status(200).json(querys);
  } catch (error) {
    return res.status(500).json({
      mensaje: 'Error al obtener los productos',
      error
    });
  }
};

module.exports = {
  getQueryFields
};
