const Producto = require('../models/Productos.js');
const { buildFileUri } = require('../config/s3.js');

const getProductos = async (req, res) => {
  const { tipo } = req.query;

  const query = { estatus: 'Activo' };
  if (tipo) {
    query.tipo_producto = tipo;
  }

  try {
    const sort = { tipo_producto: 1, cantidad: 1, nombre: 1 };

    const productos = await Producto.find(query).sort(sort);

    productos.forEach((producto) => {
      if (producto.imagen) {
        producto.imagen = buildFileUri(`productos/${producto.imagen}`);
      }
    });
    return res.status(200).json({
      mensaje: 'Productos obtenidos correctamente',
      productos
    });
  } catch (error) {
    return res.status(500).json({
      mensaje: 'Error al obtener los productos',
      error
    });
  }
};

const getProducto = async (req, res) => {
  const { id } = req.params;
  try {
    const producto = await Producto.findById(id);

    if (producto.imagen) {
      producto.imagen = buildFileUri(`productos/${producto.imagen}`);
    }

    return res.status(200).json({
      mensaje: 'Producto obtenido correctamente',
      producto
    });
  } catch (error) {
    return res.status(500).json({
      mensaje: 'Error al obtener el producto',
      error
    });
  }
};

const getLicenciaByParam = async (req, res) => {
  const { id } = req.params;
  if (!id) {
    return res.status(400).json({
      mensaje: 'El parámetro id es requerido'
    });
  }
  try {
    const producto = await Producto.findOne({ param: id, estatus: 'Activo', tipo_producto: 'Licencia' });

    if (!producto) {
      return res.status(404).json({
        mensaje: 'No se encontró la licencia'
      });
    }

    if (producto.imagen) {
      producto.imagen = buildFileUri(`productos/${producto.imagen}`);
    }

    if (producto.imagenPrincipal) {
      producto.imagenPrincipal = buildFileUri(`productos/${producto.imagenPrincipal}`);
    }

    return res.status(200).json({
      mensaje: 'Producto obtenido correctamente',
      producto
    });
  } catch (error) {
    return res.status(500).json({
      mensaje: 'Error al obtener el producto',
      error
    });
  }
};

module.exports = {
  getProductos,
  getProducto,
  getLicenciaByParam
};
