const { uploadFile } = require('../config/s3.js');

const create = async (req, res) => {
  const documento = req?.files?.documento || null;

  try {
    if (!documento) {
      return res.status(404).json({ message: 'El documento es requerido' });
    }

    const fileUpload = await uploadFile(documento, 'preview');

    return res.status(200).json(fileUpload);
  } catch (error) {
    return res.status(500).json({ message: error.message });
  }
};

module.exports = {
  create
};
