const PoderJudicialEstadoModel = require('../models/PoderJudicialEstado.js');
// const JuzgadosModel = require('../models/Juzgados.js');

const get = async (req, res) => {
  const query = { estatus: 'Activo' };
  try {
    // Ejecuta ambas consultas en paralelo
    const poderJudicial = await PoderJudicialEstadoModel.find(query)
      .populate({ path: 'estado', select: 'nombre' })
      .select('estado nombre url');

    // Ordena el resultado
    poderJudicial.sort((a, b) => a.estado.nombre.localeCompare(b.estado.nombre));

    // Envía la respuesta
    return res.status(200).json(poderJudicial);
  } catch (error) {
    console.log('Error al obtener los poderJudicial:', error);
    return res.status(500).json({
      mensaje: 'Error al obtener los poderJudicial',
      error
    });
  }
};

module.exports = {
  get
};
