const MunicipiosModel = require('../models/Municipios.js');

const getMunicipios = async (req, res) => {
  const { estado } = req.query;

  try {
    const query = {};

    if (estado) {
      query.estado = estado;
    }

    const municipios = await MunicipiosModel.find(query).sort({ nombre: 1 });

    const data = municipios.map(municipio => {
      return {
        value: municipio.id,
        label: municipio.nombre
      };
    });
    return res.status(200).json(data);
  } catch (error) {
    res.status(500).json({ message: error.message });
  }
};

module.exports = {
  getMunicipios
};
