/* eslint-disable indent */
// const UsuarioModel = require('../models/Usuarios.js');
const TipoUsuarioModel = require("../models/TipoUsuarios.js");
const ModulosModel = require("../models/Modulos.js");
const { buildFileUri } = require("../config/s3.js");
// const { countAlertas } = require('./Alertas.Controller.js');

const getModulos = async (req, res) => {
  try {
    const { usuario, creadoPor, tipoUsuario, color } = req.query;

    if (!usuario) {
      return res.status(404).json({ message: "Usuario no encontrado" });
    }

    if (usuario === creadoPor) {
      const modulosFind = await ModulosModel.find({
        estatus: "Activo",
        tipo: "despacho",
      }).sort({ orden: 1 });

      const data = modulosFind.map((modulo) => {
        const imagen =
          color === "dark"
            ? buildFileUri(`modulos/dark/${modulo.imagen}`)
            : buildFileUri(`modulos/white/${modulo.imagen}`);

        return {
          nombre: modulo.nombre,
          imagen,
          enlace: modulo.enlace,
          padre: modulo.padre,
          permisos: modulo.permisosAdmin,
          notificacion: 0,
          target: modulo.target,
          abierto: modulo?.abierto || false,
        };
      });

      const modulosPadre = data.filter((modulo) => modulo.padre === "");

      let modulos = modulosPadre.map((modulo) => {
        return {
          ...modulo,
          child: data.filter((child) => child.padre === modulo.enlace),
        };
      });

      modulos = modulos.map((modulo) => {
        modulo.child = modulo.child.map((hijo) => {
          hijo.enlace = `${hijo.enlace}`;
          return hijo;
        });

        modulo.enlace = `${modulo.enlace}`;

        return modulo;
      });

      return res.status(200).json({ data: modulos });
    }

    const tipoUsuarioModulos = await TipoUsuarioModel.findById(
      tipoUsuario
    ).populate({
      path: "modulos.modulo",
    });

    if (!tipoUsuarioModulos) {
      return res.status(404).json({ message: "Tipo de usuario no encontrado" });
    }

    // solo mostrar Modulos activos
    const data = tipoUsuarioModulos.modulos
      .map((modulo) => {
        if (
          modulo === null ||
          modulo?.modulo === null ||
          modulo?.modulo?.estatus !== "Activo"
        )
          return null;

        const imagen =
          color === "dark"
            ? buildFileUri(`modulos/dark/${modulo?.modulo?.imagen}`)
            : buildFileUri(`modulos/white/${modulo?.modulo?.imagen}`);

        return {
          nombre: modulo?.modulo?.nombre,
          imagen,
          enlace: modulo?.modulo?.enlace,
          padre: modulo?.modulo?.padre,
          orden: modulo?.modulo?.orden,
          permisos: {
            update: modulo?.permisos?.update || false,
            delete: modulo?.permisos?.delete || false,
            create: modulo?.permisos?.create || false,
            read: modulo?.permisos?.read || false,
          },
          notificacion: 0,
          target: modulo?.modulo?.target,
          abierto: modulo?.modulo?.abierto || false,
        };
      })
      .filter((modulo) => modulo !== null) // quitar módulos nulos
      .sort((a, b) => a.orden - b.orden); // ordenar Modulos

    const modulosPadre = data.filter((modulo) => modulo.padre === "");

    let modulos = modulosPadre.map((modulo) => {
      return {
        ...modulo,
        child: data.filter((child) => child.padre === modulo.enlace),
      };
    });

    // eliminar modulos y modulos hijos si no tiene permisos de show true
    modulos = modulos
      .map((modulo) => {
        // eslint-disable-next-line array-callback-return
        modulo.child = modulo?.child
          ?.map((hijo) => {
            if (hijo?.permisos?.read === true) {
              return hijo;
            } else {
              return undefined;
            }
          })
          .filter((hijo) => hijo !== undefined);

        if (modulo?.child?.length > 0 || modulo?.permisos.read === true) {
          return modulo;
        } else {
          return undefined;
        }
      })
      .filter((modulo) => modulo !== undefined)
      .sort((a, b) => a.orden - b.orden);

    res.status(200).json({ data: modulos });
  } catch (error) {
    console.log(error.message, error.stack);
    res.status(404).json({ message: error.message, line_error: error.stack });
  }
};

module.exports = {
  getModulos,
};
