const MailMasivoModel = require('../models/MailMasivo');
const DistribuidorModel = require('../models/Usuarios.js');
const DespachoModel = require('../models/Despachos.js');
const UsuarioModel = require('../models/Usuarios.js');
const { sendMail } = require('../config/mail.js');
const { APP } = require('../config/index.js')

const invitaDistribuidor = async (req, res) => {
  const { id } = req.params;
  const { correos, tipo, texto, copy, linkConferencia, activosRegistros = false, usuario, subject, fechaInicio = null } = req.body;

  if (!id) {
    return res.status(400).json({ message: 'Es necesario el id' });
  }

  if (!correos || !correos.length) {
    return res.status(400).json({ message: 'Es necesario al menos un correo' });
  }

  if (!tipo) {
    return res.status(400).json({ message: 'Es necesario el tipo' });
  }

  try {
    const findDistribuidor = await DistribuidorModel.findById(id);

    if (!findDistribuidor) {
      return res.status(404).json({ message: 'Distribuidor no encontrado' });
    }

    const nombreCompleto = `${findDistribuidor.nombre} ${findDistribuidor.apellidoPaterno || ''}`;
    const email = findDistribuidor.email;

    const newObj = {
      correos,
      invitarA: tipo,
      activosRegistros,
      linkConferencia,
      texto,
      subject,
      fechaInicio: fechaInicio || null,
      invitados: correos.map((correo) => {
        return {
          nombre: null,
          correo,
          telefono: null,
          invitacion: false
        };
      }),
      usuario
    };

    const newMailMasivo = await MailMasivoModel.create(newObj);

    console.log(newMailMasivo, 'newMailMasivo');
    const clave = newMailMasivo.clave;

    // URL de confirmación

    correos.forEach(async (correo, index) => {
      try {
        const confirmacionUrl = `${APP}/webinar/${clave}?p=${index}`;
        // Modificar el HTML para incluir el botón
        const html = `
        ${activosRegistros === true
            ? `
        <p style="text-align: center;">Para confirmar tu asistencia, haz clic en el botón de abajo:</p>
      <div style="text-align: center;">
        <a href="${confirmacionUrl}" style="
          display: inline-block;
          padding: 10px 15px;
          font-size: 16px;
          color: #ffffff;
          background-color: #021D49;
          text-decoration: none;
          border-radius: 5px;
        ">Confirmar asistencia</a>
      </div>`
            : ''}
      <p>${copy}</p>
    `;

        sendMail(
          html, // Contenido HTML del correo
          subject,
          correo, // Dirección de correo
          [], // Archivos adjuntos
          email, // Dirección del remitente
          nombreCompleto // Nombre del remitente
        );
      } catch (error) {
        console.log(`Error al enviar el correo a ${correo}:`, error);
      }
    });

    return res.status(200).json({ message: 'Correo enviado', mail: newMailMasivo });
  } catch (error) {
    console.log(error);
    return res.status(409).json({ message: error.message, error });
  }
};

const invitaDespacho = async (req, res) => {
  const { despacho } = req.params;
  const { correos, copy, usuario } = req.body;

  if (!despacho) {
    return res.status(400).json({ message: 'Es necesario el id' });
  }

  if (!correos || !correos.length) {
    return res.status(400).json({ message: 'Es necesario al menos un correo' });
  }

  try {
    const findDespacho = await DespachoModel.findById(despacho).select('nombre correo');

    if (!findDespacho) {
      return res.status(404).json({ message: 'Despacho no encontrado' });
    }

    const nombreCompleto = `${findDespacho.nombre || ''}`;
    const email = findDespacho.correo;
    const findUsuario = await UsuarioModel.findById(usuario).select('nombre apellidoPaterno apellidoMaterno');
    const nombreCompletoUsuario = `${findUsuario?.nombre || ''} ${findUsuario?.apellidoPaterno || ''} ${findUsuario?.apellidoMaterno || ''}`;
    const html = copy;

    correos.forEach(async (correo) => {
      try {
        sendMail(
          html,
          `${nombreCompletoUsuario || ''} te envió un mensaje`,
          correo,
          [],
          email,
          nombreCompleto
        );
      } catch (error) {
        console.log(`Error sending email to ${correo}:`, error);
      }
    });

    return res.status(200).json({ message: 'Correo enviado' });
  } catch (error) {
    console.log(error);
    return res.status(409).json({ message: error.message, error });
  }
};

const getInvitaciones = async (req, res) => {
  const { page = 1, search, usuario } = req.query;
  const options = {
    page,
    limit: 10,
    sort: { nombre: 1 }
  };

  try {
    const query = {};

    if (search) {
      query.subject = { $regex: search, $options: 'i' };
    }
    if (usuario) {
      query.usuario = usuario;
    }

    const invitaciones = await MailMasivoModel.paginate(query, options);
    res.status(200).json({ invitaciones });
  } catch (error) {
    res.status(404).json({ message: error.message });
  }
};

const getInvitacionByID = async (req, res) => {
  const { clave } = req.params;

  try {
    const findMail = await MailMasivoModel.findOne({ clave });

    if (!clave) {
      res.status(404).json({ message: 'Invitación no encontrada' });
    }

    res.status(200).json(findMail);
  } catch (error) {
    res.status(404).json({ message: error.message });
  }
};
const actualizarOCrearInvitado = async (req, res) => {
  const { clave } = req.params; // Obtiene la clave de la invitación de los parámetros
  const { nombre, correo, telefono } = req.body; // Obtiene el cuerpo de la solicitud

  if (!clave) {
    return res.status(400).json({ message: 'Es necesario la clave' });
  }

  if (!correo) {
    return res.status(400).json({ message: 'Es necesario el correo' });
  }

  try {
    // Buscar la invitación por la clave
    const mailMasivo = await MailMasivoModel.findOne({ clave });

    if (!mailMasivo) {
      return res.status(404).json({ message: 'Invitación no encontrada' });
    }

    // Verificar si el correo ya está en la lista de invitados
    const invitadoExistente = mailMasivo.invitados.find(inv => inv.correo === correo);

    if (invitadoExistente) {
      // Si el invitado existe, actualizar su nombre y teléfono
      invitadoExistente.nombre = nombre;
      invitadoExistente.telefono = telefono;
      invitadoExistente.invitacion = true;
      await mailMasivo.save(); // Guardar cambios en la base de datos
      return res.status(200).json({ message: 'Se ha confirmado tu invitación', invitado: invitadoExistente });
    } else {
      // Si el invitado no existe, agregar un nuevo registro
      mailMasivo.invitados.push({
        nombre,
        correo,
        telefono,
        invitacion: true // Ajusta esto según tu lógica
      });
      await mailMasivo.save(); // Guardar cambios en la base de datos
      return res.status(201).json({ message: 'Se ha confirmado tu invitación', invitado: { nombre, correo, telefono } });
    }
  } catch (error) {
    console.error(error);
    return res.status(500).json({ message: 'Error al procesar la solicitud', error });
  }
};

module.exports = { invitaDistribuidor, invitaDespacho, getInvitaciones, getInvitacionByID, actualizarOCrearInvitado };
