const Instancias = require('../models/Instancias');

const getInstacias = async (req, res) => {
  try {
    const results = await Instancias.find().sort({ order: 1 });

    const instancias = results.map((e) => {
      return {
        value: e.value,
        text: e.nombre,
        label: e.label,
        key: e._id,
        checked: e.checked || false
      };
    });

    return res.status(200).json(instancias);
  } catch (error) {
    return res.status(500).json({
      mensaje: 'Error al obtener los productos',
      error
    });
  }
};

module.exports = {
  getInstacias
};
