/* eslint-disable array-callback-return */
// /* eslint-disable array-callback-return */
const fs = require('fs');
const path = require('path');
const FirmaDocumentos = require('../models/firma_documento.js');
const { PDFDocument, rgb, StandardFonts } = require('pdf-lib');
const axios = require('axios');
const fetch = require('node-fetch');
const { uploadFileFromBuffer, buildFileUri, uploadFile, obtenerURL } = require('../config/s3.js');
const { formatDate, formatDateTime } = require('../config/functionsGlobal.js');
const { default: mongoose } = require('mongoose');
const FirmaDocumentoTodosMail = require('../Mail/FirmaDocumentoFinalizado');
const FirmaDocumentoMail = require('../Mail/FirmaDocumentoHTML.js');
const { sendMail } = require('../config/mail.js');
const UsuarioModel = require('../models/Usuarios.js');
const ClienteModel = require('../models/Clientes.js');
const DespachoModel = require('../models/Despachos.js');
const ProspectoModel = require('../models/ProspectosDespacho.js');
const DESPACHO_APP = process.env.DESPACHO_APP;
const moment = require('moment-timezone');
const FirmaDocumentoRechazado = require('../Mail/FirmaDocumentoRechazado.js');

const fetchImageAsBase64 = async (url) => {
  try {
    const response = await fetch(url);
    const buffer = await response.arrayBuffer();
    // Convertir el ArrayBuffer a base64
    const base64 = Buffer.from(buffer).toString('base64');
    return base64;
  } catch (error) {
    console.error(error, 'error fetchImageAsBase64');
  }
};

const drawImage = (page, image, x, y, width, height) => {
  page.drawImage(image, { x, y, width, height });
};

const drawAlignedText = async (page, text, x, y, fontSize, color, alignment = 'left', font, options = {}) => {
  const {
    lineHeight = 1.5, // Altura de línea por defecto
    backgroundColor = undefined, // Color de fondo opcional
    shadow = false, // Opción para sombra
    shadowOffset = { x: 1, y: -1 }, // Desplazamiento de sombra
    shadowColor = rgb(0, 0, 0) // Color de sombra
  } = options;

  const textWidth = font.widthOfTextAtSize(text, fontSize);

  // Ajustar la posición x según la alineación
  if (alignment === 'right') {
    x -= textWidth;
  } else if (alignment === 'center') {
    x -= textWidth / 2;
  }

  // Dibujar sombra si está habilitada
  if (shadow) {
    page.drawText(text, {
      x: x + shadowOffset.x,
      y: y + shadowOffset.y,
      size: fontSize,
      color: shadowColor
    });
  }

  // Dibujar el fondo si se proporciona un color
  if (backgroundColor) {
    page.drawRectangle({
      x: x - 2, // Margen para el fondo
      y: y - (fontSize * lineHeight) + 2, // Ajustar la posición vertical
      width: textWidth + 4, // Ancho con margen
      height: fontSize * lineHeight - 2, // Altura de fondo
      color: backgroundColor,
      opacity: 0.5 // Opacidad del fondo
    });
  }

  // Dibujar el texto
  page.drawText(text, {
    x,
    y,
    size: fontSize,
    color
  });
};

// Función para agregar la página al final del PDF con la información de los usuarios
// Función para agregar la página al final del PDF con la información de los usuarios
const agregarPaginaAlFinal = async (pdfData, { usuarios, logo }) => {
  try {
    const pdfDoc = await PDFDocument.load(pdfData);
    let newPage = pdfDoc.addPage(); // Tamaño A4
    const fontSize = 12;
    const margin = 50;
    let yPosition = 750;
    const maxUsersPerPage = 6; // Máximo de usuarios por página
    let userCount = 0; // Contador de usuarios en la página actual

    // Cargar la fuente Helvetica
    const font = await pdfDoc.embedFont(StandardFonts.Helvetica);
    const fontNegirtas = await pdfDoc.embedFont(StandardFonts.CourierBold);

    const logoData = await fetchImageAsBase64(logo);

    // Determinar el tipo de imagen (png o jpg)
    const imageExtension = logo.split('.').pop().toLowerCase();
    let logoImage;

    if (imageExtension === 'png') {
      logoImage = await pdfDoc.embedPng(logoData); // Para PNG
    } else if (imageExtension === 'jpg' || imageExtension === 'jpeg') {
      logoImage = await pdfDoc.embedJpg(logoData); // Para JPG
    } else {
      throw new Error('Unsupported image format');
    }

    // Ajustar el tamaño del logo
    const logoWidth = 120; // Ancho reducido
    const logoHeight = 30; // Altura reducida

    drawImage(newPage, logoImage, margin, yPosition, logoWidth, logoHeight); // Ajusta tamaño según prefieras

    // Título centrado
    await drawAlignedText(newPage, 'Firma Electrónica', newPage.getWidth() - margin, yPosition, fontSize + 4, rgb(0, 0, 0), 'right', fontNegirtas);

    // Espacio para los usuarios firmantes
    yPosition -= 40;

    for (const usuario of usuarios) {
      const { nombreCompleto, fechaFirmado, firma } = usuario;

      // Verificar si hay suficiente espacio en la página actual
      if (yPosition < 100) { // Si la posición y es menor que 100, crea una nueva página
        newPage = pdfDoc.addPage([595, 842]); // Tamaño A4
        yPosition = 750; // Reiniciar la posición y
        drawImage(newPage, logoImage, margin, yPosition, logoWidth, logoHeight); // Volver a dibujar el logo en la nueva página
        await drawAlignedText(newPage, 'Firma Electrónica', newPage.getWidth() - margin, yPosition, fontSize + 4, rgb(0, 0, 0), 'right', fontNegirtas);
        yPosition -= 40; // Ajustar espacio después del título
      }

      // Firma digital
      await drawAlignedText(newPage, `Firmado: ${nombreCompleto}`, margin, yPosition, fontSize, rgb(0, 0, 0), 'left', font);
      yPosition -= 20;
      await drawAlignedText(newPage, `Fecha: ${fechaFirmado}`, margin, yPosition, fontSize, rgb(0, 0, 0), 'left', font);

      // Cargar y dibujar la firma desde la URL
      if (firma) {
        const firmaData = await fetchImageAsBase64(firma);
        const firmaImage = await pdfDoc.embedPng(firmaData);
        yPosition -= 75;
        drawImage(newPage, firmaImage, margin, yPosition, 150, 75); // Ajusta tamaño según prefieras
      }

      yPosition -= 40; // Espacio entre firmas
      userCount++;

      // Si se han añadido 6 usuarios, crea una nueva página
      if (userCount >= maxUsersPerPage) {
        newPage = pdfDoc.addPage([595, 842]); // Tamaño A4
        yPosition = 750; // Reiniciar la posición y
        drawImage(newPage, logoImage, margin, yPosition, logoWidth, logoHeight); // Volver a dibujar el logo en la nueva página
        await drawAlignedText(newPage, 'Firma Electrónica', newPage.getWidth() - margin, yPosition, fontSize + 4, rgb(0, 0, 0), 'right', fontNegirtas);
        yPosition -= 40; // Ajustar espacio después del título
        userCount = 0; // Reiniciar el contador de usuarios
      }
    }

    // Guardar el PDF con la nueva página
    const nuevoPdfBytes = await pdfDoc.save();
    return nuevoPdfBytes;
  } catch (error) {
    console.error(error);
  }
};

const create = async (req, res) => {
  try {
    const documentoOriginal = req?.files?.documento || null;
    const { creadoPor, despacho, usuarios, clientes, prospectos, recordatorio = null, fechaExpiracion = null, nombreDocumento } = req.body;

    if (!despacho) {
      return res.status(400).json({ message: 'El despacho es requerido' });
    }

    if (!creadoPor) {
      return res.status(400).json({ message: 'El usuario que crea la alerta es requerido' });
    }

    const fotoUpdate = await uploadFile(documentoOriginal, 'firma_documentos');

    const idsUsuarios = usuarios?.trim() ? usuarios.split(',') : [];
    const idsClientes = clientes?.trim() ? clientes.split(',') : [];
    const idsProspectos = prospectos?.trim() ? prospectos.split(',') : [];

    const objNew = {
      creadoPor: mongoose.Types.ObjectId(creadoPor),
      usuarios: idsUsuarios?.map((usuario) => {
        return {
          usuario: mongoose.Types.ObjectId(usuario),
          estatus: 'Sin firmar',
          fechaFirmado: null,
          firma: null
        };
      }),
      clientes: idsClientes?.map((cliente) => {
        return {
          cliente: mongoose.Types.ObjectId(cliente),
          estatus: 'Sin firmar',
          fechaFirmado: null,
          firma: null
        };
      }),
      prospectos: idsProspectos?.map((prospecto) => {
        return {
          prospecto: mongoose.Types.ObjectId(prospecto),
          estatus: 'Sin firmar',
          fechaFirmado: null,
          firma: null
        };
      }),
      despacho,
      fechaExpiracion,
      documentoOriginal: fotoUpdate.fileName,
      nombreDocumento,
      recordatorio
    };

    // const newAlerta = await FirmaDocumentos.create(objNew);

    const [newAlerta, findUsuarios, findClientes, findProspectos, findCreador] = await Promise.all([
      FirmaDocumentos.create(objNew),
      idsUsuarios.length > 0 ? UsuarioModel.find({ _id: { $in: idsUsuarios } }).select('nombre apellidoPaterno apellidoMaterno email') : [],
      idsClientes.length > 0 ? ClienteModel.find({ _id: { $in: idsClientes } }).select('nombre correo') : [],
      idsProspectos.length > 0 ? ProspectoModel.find({ _id: { $in: idsProspectos } }).select('nombre correo') : [],
      UsuarioModel.findById(creadoPor).select('nombre apellidoPaterno apellidoMaterno')
    ]);

    const nombreEnviado = `${findCreador?.nombre || ''} ${findCreador?.apellidoPaterno || ''} ${findCreador?.apellidoMaterno || ''}`;

    for (const user of findUsuarios) {
      const nombreRecibido = `${user?.nombre || ''} ${user?.apellidoPaterno || ''} ${user?.apellidoMaterno || ''}`;
      const rutaFirma = `${DESPACHO_APP}/firma/${newAlerta?._id}/${user?._id}/u`;
      const html = FirmaDocumentoMail({ nombreEnviado, nombreRecibido, nombreDocumento, rutaFirma });
      sendMail(html, `${findCreador?.nombre || ''} te ha invitado a firmar un documento`, user?.email);
    }

    for (const cli of findClientes) {
      const nombreRecibido = `${cli?.nombre || ''}`;
      const rutaFirma = `${DESPACHO_APP}/firma/${newAlerta?._id}/${cli?._id}/c`;
      const html = FirmaDocumentoMail({ nombreEnviado, nombreRecibido, nombreDocumento, rutaFirma });

      sendMail(html, `${findCreador?.nombre || ''} te ha invitado a firmar un documento`, cli?.correo);
    }

    for (const pros of findProspectos) {
      const nombreRecibido = `${pros?.nombre || ''}`;
      const rutaFirma = `${DESPACHO_APP}/firma/${newAlerta?._id}/${pros?._id}/p`;
      console.log(rutaFirma);
      const html = FirmaDocumentoMail({ nombreEnviado, nombreRecibido, nombreDocumento, rutaFirma });

      sendMail(html, `${findCreador?.nombre || ''} te ha invitado a firmar un documento`, pros?.correo);
    }

    res.status(201).json({
      message: 'Documento enviado',
      asunto: newAlerta
    });
  } catch (error) {
    console.log(error);
    res.status(404).json({
      message: error.message
    });
  }
};

const get = async (req, res) => {
  const { despacho } = req.params;
  const { estatus, page = 1, search, usuario } = req.query;

  const options = {
    page,
    limit: 10,
    sort: {
      estatus: 1,
      creadoFecha: -1
    },
    lean: true,
    select: 'nombreDocumento estatus usuarios clientes creadoFecha fechaExpiracion documentoFirmado documentoOriginal firmado prospectos',
    populate: [
      {
        path: 'usuarios.usuario',
        select: 'nombre apellidoPaterno apellidoMaterno foto'
      },
      {
        path: 'clientes.cliente',
        select: 'nombre foto'
      },
      {
        path: 'prospectos.prospecto',
        select: 'nombre'
      }
    ]

  };

  if (!despacho) {
    return res.status(400).json({ message: 'El despacho es requerido' });
  }

  const query = {
    despacho
  };

  if (usuario) {
    query.creadoPor = usuario;
  }

  if (search) {
    query.nombreDocumento = { $regex: search, $options: 'i' };
  }

  if (estatus) {
    query.estatus = estatus;
  }

  try {
    const findDocumentos = await FirmaDocumentos.paginate(query, options);

    const documentos = [];
    for (const index in findDocumentos.docs) {
      const documento = findDocumentos.docs[index];
      let participantes = [];

      const usuariosListado = [];
      for (const usuIndex in documento.usuarios) {
        const usu = documento.usuarios[usuIndex];
        let foto = '';

        if (usu?.usuario?.foto) {
          foto = buildFileUri(`usuarios/${usu?.usuario?.foto}`);
        } else {
          foto = buildFileUri('default/icono_usuario_100x100_04.jpg');
        }

        usuariosListado.push({
          nombreCompleto: `${usu?.usuario?.nombre || ''} ${usu?.usuario?.apellidoPaterno || ''} ${usu?.usuario?.apellidoMaterno || ''}`,
          estatus: usu.estatus,
          fechaExpiracion: formatDateTime(usu.fechaFirmado),
          foto,
          comentario: usu.comentario || ''
        });
      }

      const clientesListado = [];
      for (const cliIndex in documento.clientes) {
        const cli = documento.clientes[cliIndex];
        let foto = '';

        if (cli?.cliente.foto) {
          foto = buildFileUri(`clientes/${cli?.cliente?.foto}`);
        } else {
          foto = buildFileUri('default/icono_usuario_100x100_04.jpg');
        }

        clientesListado.push({
          nombreCompleto: `${cli?.cliente?.nombre || ''}`,
          estatus: cli.estatus,
          fechaExpiracion: formatDateTime(cli?.fechaFirmado || '') || '',
          foto,
          comentario: cli.comentario
        });
      }

      const prospectosListado = [];
      for (const prospecto in documento.prospectos) {
        const pros = documento.prospectos[prospecto];
        const foto = buildFileUri('default/icono_usuario_100x100_04.jpg');

        prospectosListado.push({
          nombreCompleto: `${pros?.prospecto?.nombre || ''}`,
          estatus: pros.estatus,
          fechaExpiracion: formatDateTime(pros.fechaFirmado || ''),
          foto,
          comentario: pros.comentario
        });
      }

      participantes = [
        ...usuariosListado,
        ...clientesListado,
        ...prospectosListado
      ];

      documentos.push({
        _id: documento._id,
        participantes,
        nombre: documento.nombreDocumento,
        creado: formatDate(documento.creadoFecha),
        estatus: documento.estatus,
        firmadoFecha: formatDate(documento.firmado),
        fechaExpiracion: formatDate(documento.fechaExpiracion),
        // original: buildFileUri('firma_documentos/' + documento.documentoOriginal),
        original: await obtenerURL(`firma_documentos/${documento.documentoOriginal}`, `${documento.nombreDocumento}_original.pdf`),
        // firmado: documento.documentoFirmado ? buildFileUri(documento.documentoFirmado) : null
        firmado: documento.documentoFirmado ? await obtenerURL(`firma_documentos/${documento.documentoFirmado}`, `${documento.nombreDocumento}_firmado.pdf`) : null
      });
    }

    findDocumentos.docs = documentos;

    return res.status(200).json(findDocumentos);
  } catch (error) {
    return res.status(404).json({ message: error.message });
  }
};

const firmarDocumentoUsuario = async (req, res) => {
  const { id, participante, tipo, imageBase64 } = req.body;

  if (!imageBase64) {
    return res.status(400).json({ message: 'Es requerido la imageBase64' });
  }

  try {
    const imageBuffer = Buffer.from(imageBase64.replace(/^data:image\/png;base64,/, ''), 'base64');

    // Nombre del archivo temporal
    const tempFilePath = path.join('/tmp', 'firma.png');

    // Guardar la imagen en /tmp
    fs.writeFileSync(tempFilePath, imageBuffer);

    // Crear el objeto con la información necesaria para la carga
    const file = {
      buffer: imageBuffer,
      originalname: 'firma.png',
      mimetype: 'image/png',
      tempFilePath,
      name: 'firma.png'
    };

    // Llamar a uploadFile con el objeto completo
    const uploadFirmaS3 = await uploadFile(file, 'firma_documentos/firma');

    fs.unlinkSync(tempFilePath);

    const find = await FirmaDocumentos.findById(id)
      .populate({
        path: 'usuarios.usuario', // Población de los usuarios dentro del array
        select: 'nombre apellidoPaterno apellidoMaterno email foto'
      })
      .populate({
        path: 'clientes.cliente', // Población de los clientes dentro del array
        select: 'nombre correo foto'
      }).populate({
        path: 'prospectos.prospecto', // Población de los prospectos dentro del array
        select: 'nombre correo'
      }).populate({
        path: 'creadoPor',
        select: 'nombre apellidoPaterno apellidoMaterno email'
      });

    if (!find) {
      return res.status(400).json({ message: 'No se encontró la firma' });
    }

    if (tipo === 'u' && participante) {
      const _idUsuario = participante;
      const busca = find.usuarios.find(u => u.usuario._id.toString() === _idUsuario.toString());

      if (!busca) {
        return res.status(400).json({ message: 'Usuario no encontrado en el documento' });
      }

      busca.estatus = 'Firmado';
      busca.fechaFirmado = moment().tz('America/Mexico_City');
      const uploadFirma = uploadFirmaS3.fileName;
      busca.firma = uploadFirma;

      find.markModified('usuarios');

      await find.save();
    } else if (tipo === 'c' && participante) {
      const _idCliente = participante;
      const busca = find.clientes.find(u => u.cliente._id.toString() === _idCliente.toString());

      if (!busca) {
        return res.status(400).json({ message: 'Cliente no encontrado en el documento' });
      }

      busca.estatus = 'Firmado';
      busca.fechaFirmado = moment().tz('America/Mexico_City');
      const uploadFirma = uploadFirmaS3.fileName;
      busca.firma = uploadFirma;

      find.markModified('clientes');

      await find.save();
    } else if (tipo === 'p' && participante) {
      const _idProspecto = participante;
      const busca = find.prospectos.find(u => u.prospecto._id.toString() === _idProspecto.toString());

      if (!busca) {
        return res.status(400).json({ message: 'Prospecto no encontrado en el documento' });
      }

      busca.estatus = 'Firmado';
      busca.fechaFirmado = moment().tz('America/Mexico_City');
      const uploadFirma = uploadFirmaS3.fileName;
      busca.firma = uploadFirma;

      find.markModified('prospectos');

      await find.save();
    }

    let firmadoCliente = true;
    let firmadoUsuarios = true;
    let firmadoProspectos = true;

    for (const usuario of find.usuarios) {
      if (usuario.estatus === 'Sin firmar') {
        firmadoUsuarios = false;
        break;
      }
    }

    for (const cliente of find.clientes) {
      if (cliente.estatus === 'Sin firmar') {
        firmadoCliente = false;
        break;
      }
    }

    for (const prospecto of find.prospectos) {
      if (prospecto.estatus === 'Sin firmar') {
        firmadoProspectos = false;
        break;
      }
    }

    if (firmadoCliente && firmadoUsuarios && firmadoProspectos) {
      find.estatus = 'Firmado';
      find.firmado = moment().tz('America/Mexico_City');

      const pdfOriginal = buildFileUri(`firma_documentos/${find.documentoOriginal}`);

      const usuariosObj = find?.usuarios?.map((u) => {
        return {
          nombreCompleto: `${u?.usuario?.nombre || ''} ${u?.usuario?.apellidoPaterno || ''} ${u?.usuario?.apellidoMaterno || ''}`,
          fechaFirmado: formatDateTime(u?.fechaFirmado),
          firma: buildFileUri(`firma_documentos/firma/${u.firma}`)
        };
      }) || [];

      const clientessObj = find?.clientes?.map((c) => {
        return {
          nombreCompleto: `${c?.cliente?.nombre || ''}`,
          fechaFirmado: formatDateTime(c?.fechaFirmado),
          firma: buildFileUri(`firma_documentos/firma/${c.firma}`)
        };
      }) || [];

      const prospectosObj = find?.prospectos?.map((p) => {
        return {
          nombreCompleto: `${p?.prospecto?.nombre || ''}`,
          fechaFirmado: formatDateTime(p?.fechaFirmado),
          firma: buildFileUri(`firma_documentos/firma/${p.firma}`)
        };
      }) || [];

      const usuarios = [...usuariosObj, ...clientessObj, ...prospectosObj];

      const findDespacho = await DespachoModel.findById(find.despacho).select('logo');

      let logo = '';

      if (!findDespacho) {
        logo = 'https://nildda.com/images/logo/logo_nildda_172x42.png';
      } else {
        if (findDespacho.logo) {
          logo = buildFileUri(`despachos/${findDespacho?._id}/logo/${findDespacho.logo}`);
        } else {
          logo = 'https://nildda.com/images/logo/logo_nildda_172x42.png';
        }
      }

      const response = await axios.get(pdfOriginal, { responseType: 'arraybuffer' });

      const pdfData = response.data;

      // Llamar a la función para agregar la página al final
      const nuevoPdfBuffer = await agregarPaginaAlFinal(pdfData, { logo, usuarios });

      const fileUpload = await uploadFileFromBuffer(nuevoPdfBuffer, 'firma_documentos');

      find.documentoFirmado = fileUpload?.fileName || '';

      await find.save();

      const rutaFirma = buildFileUri(`firma_documentos/${find.documentoFirmado}`);

      const html = FirmaDocumentoTodosMail({ nombreDocumento: find.nombreDocumento, nombreRecibido: find.creadoPor.nombre, rutaFirma });
      sendMail(html, `El documento ${find.nombreDocumento}.pdf ha sido firmado por todos los firmantes`, find?.creadoPor.email);
    }

    return res.status(200).json({ message: 'Se firmo correctamente el documento' });
  } catch (error) {
    console.log(error);
    return res.status(500).json({ message: 'Error al firmar el documento', error: error.message });
  }
};

const getByID = async (req, res) => {
  const { id } = req.params;
  const { participante, tipo } = req.query;

  try {
    const find = await FirmaDocumentos.findById(id);

    if (!find) {
      return res.status(400).json({ message: 'No se encontró la firma' });
    }

    if (find.fechaExpiracion) {
      const isExpired = moment().isAfter(find.fechaExpiracion);

      if (isExpired) {
        return res.status(400).json({ message: 'El tiempo limite de la firma ha finalizado' });
      }
    }

    let documentoFirmadoParticpante = false;
    if (tipo === 'u' && participante) {
      const _idUsuario = participante;
      const busca = find.usuarios.find(u => u.usuario.toString() === _idUsuario.toString());

      if (!busca) {
        return res.status(400).json({ message: 'Usuario no encontrado en el documento' });
      }

      // Aquí puedes acceder a los detalles del usuario encontrado
      documentoFirmadoParticpante = busca.estatus === 'Firmado';
    } else if (tipo === 'c' && participante) {
      const _idCliente = participante;
      const busca = find.clientes.find(u => u.cliente.toString() === _idCliente.toString());

      if (!busca) {
        return res.status(400).json({ message: 'Cliente no encontrado en el documento' });
      }

      // Aquí puedes acceder a los detalles del usuario encontrado
      documentoFirmadoParticpante = busca.estatus === 'Firmado';
    } else if (tipo === 'p' && participante) {
      const _idParticipante = participante;
      console.log(find.prospectos, participante);
      console.log('6717fbb3f0a717e877cd9dff');
      const busca = find.prospectos.find(u => u.prospecto.toString() === _idParticipante.toString());

      if (!busca) {
        return res.status(400).json({ message: 'Prospecto no encontrado en el documento' });
      }

      // Aquí puedes acceder a los detalles del usuario encontrado
      documentoFirmadoParticpante = busca.estatus === 'Firmado';
    };

    find.documentoFirmadoParticpante = documentoFirmadoParticpante;
    find.documentoOriginal = await obtenerURL(`firma_documentos/${find.documentoOriginal}`, `${find.nombreDocumento}_original.pdf`);

    let documentoFirmado = null;

    if (find.documentoFirmado) {
      documentoFirmado = await obtenerURL(`firma_documentos/${find.documentoFirmado}`, `${find.nombreDocumento}_firmado.pdf`);
    }

    return res.status(200).json({ find, documentoFirmadoParticpante, documentoFirmado });
  } catch (error) {
    console.log(error);
    res.status(404).json({
      message: error.message
    });
  }
};

const RechazarDocumento = async (req, res) => {
  const { comentario, id, participante, tipo } = req.body;

  try {
    let nombreRechazante = '';

    const find = await FirmaDocumentos.findById(id)
      .populate({
        path: 'usuarios.usuario', // Población de los usuarios dentro del array
        select: 'nombre apellidoPaterno apellidoMaterno email foto'
      })
      .populate({
        path: 'clientes.cliente', // Población de los clientes dentro del array
        select: 'nombre correo foto'
      }).populate({
        path: 'prospectos.prospecto', // Población de los prospectos dentro del array
        select: 'nombre correo'
      }).populate({
        path: 'creadoPor',
        select: 'nombre apellidoPaterno apellidoMaterno email'
      });

    if (tipo === 'u' && participante) {
      const _idUsuario = participante;
      const busca = find.usuarios.find(u => u.usuario?._id.toString() === _idUsuario.toString());

      console.log(busca);
      if (!busca) {
        return res.status(400).json({ message: 'Usuario no encontrado en el documento' });
      }

      nombreRechazante = `${busca?.usuario?.nombre || ''} ${busca?.usuario?.apellidoPaterno || ''} ${busca?.usuario?.apellidoMaterno || ''}`;
      busca.comentario = comentario;
      busca.estatus = 'Rechazado';
      busca.fechaFirmado = moment().tz('America/Mexico_City');

      find.markModified('usuarios');
      find.estatus = 'Rechazado';

      await find.save();
    } else if (tipo === 'c' && participante) {
      const _idCliente = participante;
      const busca = find.clientes.find(c => c.cliente._id.toString() === _idCliente.toString());

      if (!busca) {
        return res.status(400).json({ message: 'Cliente no encontrado en el documento' });
      }

      nombreRechazante = `${busca?.usuario?.nombre || ''}`;
      busca.comentario = comentario;
      busca.estatus = 'Rechazado';
      busca.fechaFirmado = moment().tz('America/Mexico_City');

      find.markModified('clientes');
      find.estatus = 'Rechazado';

      await find.save();
    } else if (tipo === 'p' && participante) {
      const _idProspecto = participante;
      const busca = find.prospectos.find(u => u.prospecto._id.toString() === _idProspecto.toString());

      if (!busca) {
        return res.status(400).json({ message: 'Prospecto no encontrado en el documento' });
      }

      nombreRechazante = `${busca?.usuario?.nombre || ''}`;
      busca.comentario = comentario;
      busca.estatus = 'Rechazado';
      busca.fechaFirmado = moment().tz('America/Mexico_City');

      find.markModified('prospectos');
      find.estatus = 'Rechazado';

      await find.save();
    }
    const nombreRecibido = `${find?.creadoPor.nombre || ''} ${find?.creadoPor.apellidoPaterno || ''} ${find?.creadoPor.apellidoMaterno || ''}`;
    const nombreDocumento = `${find?.nombreDocumento}.pdf`;

    const html = FirmaDocumentoRechazado({ nombreRecibido, nombreDocumento, comentario, nombreRechazante });
    sendMail(html, `El documento ${find.nombreDocumento}.pdf ha sido rechazado por ${nombreRechazante}`, find?.creadoPor.email);

    return res.status(200).json({ message: 'Documento rechazado' });
  } catch (error) {
    console.error(error);
    res.status(404).json({ message: error.message });
  }
};

module.exports = {
  create,
  get,
  getByID,
  firmarDocumentoUsuario,
  RechazarDocumento
};
