const Epocas = require('../models/Epocas');

const getEpocas = async (req, res) => {
  try {
    const results = await Epocas.find().sort({ order: 1 });

    const epocas = results.map((e) => {
      return {
        value: e.value,
        text: e.nombre,
        label: e.label,
        key: e._id,
        checked: e.checked || false
      };
    });

    return res.status(200).json(epocas);
  } catch (error) {
    return res.status(500).json({
      mensaje: 'Error al obtener los productos',
      error
    });
  }
};

module.exports = {
  getEpocas
};
