/* eslint-disable array-callback-return */
const axios = require('axios');

const getNotes = async (req, res) => {
  const { search, limit = 10, page = 1 } = req.query;

  try {
    const uri = 'https://sidof.segob.gob.mx/busqueda/cargaNotas/';

    const data = {
      draw: 1,
      'columns[0][data]': 'fecha',
      'columns[0][name]': '',
      'columns[0][searchable]': true,
      'columns[0][orderable]': true,
      'columns[0][search][value]': '',
      'columns[0][search][regex]': false,
      'columns[1][data]': 'titulo',
      'columns[1][name]': '',
      'columns[1][searchable]': true,
      'columns[1][orderable]': true,
      'columns[1][search][value]': '',
      'columns[1][search][regex]': false,
      'columns[2][data]': 'codOrgaUno',
      'columns[2][name]': '',
      'columns[2][searchable]': true,
      'columns[2][orderable]': true,
      'columns[2][search][value]': '',
      'columns[2][search][regex]': false,
      'columns[3][data]': 'codOrgaDos',
      'columns[3][name]': '',
      'columns[3][searchable]': true,
      'columns[3][orderable]': true,
      'columns[3][search][value]': '',
      'columns[3][search][regex]': false,
      'order[0][column]': 0,
      'order[0][dir]': 'desc',
      start: limit * page - limit,
      length: limit,
      'search[value]': '',
      'search[regex]': false,
      dato: search
    };

    const headers = {
      Accept: 'application/json, text/javascript, */*; q=0.01',
      'Accept-Encoding': 'gzip, deflate, br, zstd',
      'Accept-Language': 'en-US,en;q=0.9',
      Connection: 'keep-alive',
      'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8',
      Host: 'sidof.segob.gob.mx'
    };

    const response = await axios.post(uri, data, {
      headers
    });

    return res.status(200).json(response.data);
  } catch (error) {
    console.error('Error en DOF:', error);
    return res.status(500).json({ message: error.message });
  }
};

const getNoteById = async (req, res) => {
  const { id } = req.params;
  if (!id) {
    return res.status(400).json({ message: 'Hace falta el identificador' });
  }

  try {
    const uri = `https://sidof.segob.gob.mx/notas/docFuente/${id}`;
    // const { chromium } = require('playwright');

    // const getWebData = async () => {
    //   const browser = await chromium.launch();
    //   const page = await browser.newPage();
    //   await page.goto(`https://sidof.segob.gob.mx/notas/${id}/`);

    //   await page.waitForSelector('.container-fluid');

    //   const data = await page.evaluate(() => {
    //     const imagesValue = window.images;

    //     const targetDiv = document.querySelector('.container-fluid');
    //     // const targetContent = targetDiv ? targetDiv.outerHTML : null;
    //     const targetContent = targetDiv ? targetDiv.innerText : null;

    //     return { imagesValue, targetContent };
    //   });

    //   await browser.close();
    //   return data;
    // };

    const axiosResponse = await axios.get(uri);

    // const playwrightPromise = getWebData();

    // const [axiosResponse] = await Promise.all([
    //   axiosPromise
    //   // playwrightPromise
    // ]);

    let data;
    let tipo;

    if (axiosResponse && axiosResponse.status === 200 && axiosResponse.data) {
      data = axiosResponse.data;
      tipo = 'html';

      return res.status(200).json({ data, tipo });
    } else {
      return res.status(404).json({ message: 'No se encontraron datos' });
    }
    // else if (webData && webData.imagesValue && webData.imagesValue.lista) {
    // webData.imagesValue.lista.forEach((e) => {
    //   e.src = `https://sidof.segob.gob.mx${e.src}`;
    // });

    // data = webData.imagesValue.lista.map((e) => e.src);
    // tipo = 'images';

    // return res.status(200).json({ data, tipo });
    // }
  } catch (error) {
    console.error('Error en la obtención de datos:', error);
    return res.status(500).json({ message: error.message });
  }
};

module.exports = {
  getNotes,
  getNoteById
};
