const { buildFileUri } = require('../config/s3.js');
const UsuarioModel = require('../models/Usuarios.js');

const getDespachoUsuariosSinPaginar = async (req, res) => {
  const { despacho } = req.params;

  if (!despacho) {
    return res.status(400).json({ message: 'El despacho es requerido' });
  }

  try {
    const findUsuario = await UsuarioModel.find({ despacho, estatus: 'Activo' }).sort({ nombre: 1 });

    const usuarios = findUsuario.map((usuario) => {
      return {
        value: usuario._id,
        label: `${usuario.nombre} ${usuario.apellidoPaterno} ${usuario.apellidoMaterno}`,
        foto: usuario.foto ? buildFileUri(`usuarios/${usuario.foto}`) : buildFileUri('default/icono_usuario_100x100_04.jpg')
      };
    });

    res.status(200).json(usuarios);
  } catch (error) {
    res.status(404).json({ message: error.message });
  }
};

module.exports = {
  getDespachoUsuariosSinPaginar
};
