const UsuarioModel = require('../models/Usuarios.js');
const getDatosParaCorrida = async (req, res) => {
  const { distribuidor } = req.params;

  try {
    const findDistribuidor = await UsuarioModel.findById(distribuidor).populate('licencia.producto');

    if (!findDistribuidor) {
      return res.status(404).json({ message: 'Distribuidor no encontrado' });
    }

    const repuesta = {
      nombreLicencia: 'Licencia ' + findDistribuidor?.licencia?.producto?.nombre || '',
      utilidad: findDistribuidor?.licencia?.comision || 0,
      inversion: findDistribuidor?.licencia?.producto?.precio || 0
    };

    return res.status(200).json(repuesta);
  } catch (error) {
    console.log(error);
    res.status(500).json({ message: 'Error al obtener los datos para la corrida' });
  }
};

module.exports = {
  getDatosParaCorrida
};
