const CopyPsdModel = require('../models/CopyPsd.js');
const CopyUsuarioModel = require('../models/CopyUsuario.js');

const getCopy = async (req, res) => {
  const { type, dirigido } = req.params;
  const { estatus, page = 1, search } = req.query;

  const options = {
    page,
    limit: 10,
    sort: { estatus: 1, nombre: 1 }

  };

  const query = {
    type,
    dirigido
  };

  if (estatus) {
    query.estatus = estatus;
  }

  if (search) {
    query.nombre = { $regex: search, $options: 'i' };
  }

  try {
    const findCopy = await CopyPsdModel.paginate(query, options);

    res.status(200).json({ copy: findCopy });
  } catch (error) {
    res.status(404).json({ message: error.message });
  }
};

const getCopyPagination = async (req, res) => {
  const { type, dirigido } = req.params;
  const { usuario } = req.query;

  const query = {
    type,
    dirigido,
    estatus: 'Activo'
  };

  try {
    const queryUsuario = { ...query, usuario };

    // Consultas simultáneas
    const [findCopy, findCopyUsuario] = await Promise.all([
      CopyPsdModel.find(query),
      CopyUsuarioModel.find(queryUsuario)
    ]);

    // Combinar resultados en un solo arreglo
    const combinedResults = [...findCopy, ...findCopyUsuario];

    res.status(200).json({ copy: combinedResults });
  } catch (error) {
    res.status(404).json({ message: error.message });
  }
};

const updateCopyUsuarioOrCreate = async (req, res) => {
  const { _id, usuario, nombre, copy, type, dirigido } = req.body;

  try {
    console.log(_id, usuario, nombre, type, dirigido);
    // Await the findById result
    const findPsd = await CopyUsuarioModel.findById(_id);

    if (!findPsd) {
      // Create a new document if it doesn't exist
      const copySave = await CopyUsuarioModel.create({
        usuario,
        nombre,
        copy,
        type,
        dirigido
      });
      return res.status(200).json({ message: 'Copy creado correctamente', copy: copySave });
    } else {
      // Update the existing document
      findPsd.usuario = usuario;
      findPsd.nombre = nombre;
      findPsd.copy = copy;
      findPsd.type = type;
      findPsd.dirigido = dirigido;

      await findPsd.save(); // Save the updated document
      return res.status(200).json({ message: 'Copy editado correctamente', copy: findPsd });
    }
  } catch (error) {
    console.log(error.message);
    return res.status(500).json({ message: error.message }); // Change to 500 for server error
  }
};

module.exports = {
  getCopy,
  getCopyPagination,
  updateCopyUsuarioOrCreate
};
