const axios = require('axios');
const getCedulas = async (req, res) => {
  const { nombre, paterno, materno } = req.query;

  try {
    // Configura el payload y las cabeceras
    const body = {
      json: JSON.stringify({
        maxResult: '1000',
        nombre,
        paterno,
        materno,
        idCedula: ''
      })
    };

    const headers = {
      'User-Agent': 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:132.0) Gecko/20100101 Firefox/132.0',
      Accept: '*/*',
      'Accept-Language': 'es-MX,es;q=0.8,en-US;q=0.5,en;q=0.3',
      'Content-Type': 'application/x-www-form-urlencoded; charset=utf-8',
      'X-Requested-With': 'XMLHttpRequest',
      'Sec-Fetch-Dest': 'empty',
      'Sec-Fetch-Mode': 'cors',
      'Sec-Fetch-Site': 'same-origin',
      Priority: 'u=0',
      Referer: 'https://www.cedulaprofesional.sep.gob.mx/cedula/presidencia/indexAvanzada.action'
    };

    // Realiza la solicitud POST
    const response = await axios.post(
      'https://www.cedulaprofesional.sep.gob.mx/cedula/buscaCedulaJson.action',
      new URLSearchParams(body).toString(),
      { headers }
    );

    // Envia la respuesta obtenida del servidor
    res.status(200).json(response?.data?.items);
    console.log(response.data);
  } catch (error) {
    console.error('Error al buscar la cédula profesional:', error);
    res.status(500).json({ error: 'Error al realizar la solicitud' });
  }
};

module.exports = {
  getCedulas
};
