const BancosSchema = require('../models/Bancos.js');

const getBancos = async (req, res) => {
  try {
    const findBancos = await BancosSchema.find().sort({ banco: 1 });
    const bancos = findBancos.map((banco) => {
      return {
        _id: banco._id,
        banco: banco.banco,
        label: banco.banco,
        key: banco._id,
        value: banco._id,
        clave: banco.clave
      };
    });

    res.status(200).json(bancos);
  } catch (error) {
    res.status(404).json({ message: error.message });
  }
};

module.exports = {
  getBancos
};
