const UsuarioModel = require("../models/Usuarios.js");
const ClienteModel = require("../models/Clientes.js");
const {
  enviaCodigoWhatsApp,
  encriptar,
  generateRandomNumbers,
} = require("../config/functionsGlobal.js");
const CodigoVerificacionHTML = require("../Mail/CodigoVerificacionHTML.js");
const { sendMail } = require("../config/mail.js");
const bcrypt = require("bcryptjs");

const MandarCodigo = async (req, res) => {
  const { correo } = req.body;
  const codigo = generateRandomNumbers();

  try {
    if (!correo) {
      return res.status(400).json({ message: "El correo es requerido" });
    }

    // Buscar en Usuarios
    let findUsuario = await UsuarioModel.findOne({
      email: correo,
      estatus: "Activo",
    });

    // Si no está en usuarios, buscar en clientes
    if (!findUsuario) {
      findUsuario = await ClienteModel.findOne({ correo, estatus: "Activo" });
    }

    if (!findUsuario) {
      return res
        .status(404)
        .json({ message: "No se encontró ningún usuario con ese correo" });
    }

    // Enviar correo
    const html = CodigoVerificacionHTML(codigo);
    await sendMail(html, "NILDDA: Código de verificación", correo);

    return res.status(200).json({
      message: `Se ha enviado un código al correo: ${correo}`,
      codigo,
      usuario: { _id: findUsuario._id },
    });
  } catch (error) {
    console.error(error);
    return res
      .status(400)
      .json({ message: "Ocurrió un error, inténtalo más tarde" });
  }
};

const actualizarContraseña = async (req, res) => {
  const { tipo, id, nuevaPassword } = req.body;
  try {
    const password = encriptar(nuevaPassword);

    if (tipo === "usuario") {
      const updatedUser = await UsuarioModel.findByIdAndUpdate(
        id,
        { $set: { password } },
        { new: true }
      );

      if (!updatedUser) {
        return res.status(400).json({ message: "El usuario no se encontró." });
      }

      return res
        .status(200)
        .json({ message: "Se ha actualizado la contraseña." });
    } else {
      const updatedUser = await ClienteModel.findByIdAndUpdate(
        id,
        { $set: { password } },
        { new: true }
      );

      if (!updatedUser) {
        return res.status(400).json({ message: "El cliente no se encontró." });
      }

      return res
        .status(200)
        .json({ message: "Se ha actualizado la contraseña." });
    }
  } catch (error) {
    console.error(error);
    return res
      .status(400)
      .json({ message: "Corrió un error, inténtelo más tarde." });
  }
};

const MandarCodigoUsuario = async (req, res) => {
  const { id, tipo } = req.body;
  try {
    const find = await UsuarioModel.findById(id);

    if (!find) {
      return res.status(400).json({ message: "No se encontró el usuario" });
    }

    const codigo = generateRandomNumbers();
    const por = tipo === "phone" ? "WhatsApp" : "Correo electrónico";
    const enviado = tipo === "phone" ? find?.telefono || "" : find?.email || "";

    if (tipo === "phone") {
      await enviaCodigoWhatsApp({ to: find?.telefono, codigo });
    } else if (tipo === "email") {
      const htmlRegistro = CodigoVerificacionHTML(codigo);

      sendMail(htmlRegistro, "NILDDA: Código de verificación", find?.email);
    }

    return res.status(200).json({
      message: `Se te ha enviado un código de verificación al ${por}: ${enviado}`,
      codigo,
    });
  } catch (error) {
    console.error(error);
    res.status(400).json({ message: "Corrió un error inténtelo más tarde" });
  }
};

module.exports = {
  MandarCodigo,
  actualizarContraseña,
  MandarCodigoUsuario,
};
