const nodemailer = require('nodemailer');

const host = process.env.MAIL_HOST;
const port = process.env.MAIL_PORT;
const user = process.env.MAIL_USER;
const pass = process.env.MAIL_PASS;

const transporter = nodemailer.createTransport({
  host,
  port,
  auth: {
    user,
    pass
  }
});

const sendMail = async (html, subject, correos, files = [], from = null, nombre = null) => {
  try {
    let fromA = `<${user}> "NILDDA" `;
    if (from) {
      fromA = `<${from}> "${nombre}" `;
    }

    console.log('📤 Enviando correo a:', correos);

    const mailOptions = {
      from: fromA,
      to: correos,
      subject,
      html,
      attachments: files
    };

    const info = await transporter.sendMail(mailOptions);
    return info;
  } catch (error) {
    console.log('Error al enviar correo', error);
    return error;
  }
};


module.exports = { sendMail };
