/* eslint-disable n/handle-callback-err */
const { Buffer } = require("buffer");
// const Twilio = require('twilio');
const fs = require("fs");
const accountSid = process.env.TWILIO_ACCOUNT_SID || "";
const authToken = process.env.TWILIO_AUTH_TOKEN || "";
const DespachoModel = require("../models/Despachos.js");
const client = require("twilio")(accountSid, authToken);

const arregloCaracteres =
  "a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z,A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z,1,2,3,4,5,6,7,8,9,0,Ñ,ñ,\\,$,.,?,=,!,/,:,_,+,*".split(
    ","
  );
const arregloModificador =
  "9z,1y,8x,2w,7v,3u,6t,4s,5r,0q,9P,1O,8N,2M,7A,3B,6C,4D,5E,0F,aZ,bY,cX,dW,eV,gt,Sh,Ri,Qj,Pk,Ol,Nm,Mn,Ao,Bp,Cq,Dr,Es,Ft,Gu,Hv,Iw,Jx,Ky,Lz,1Z,0Q,2Y,9R,3X,8S,4W,zw,ys,xx,wr,vy,uq,tz,sz,ry,qx,Wz,Sy,3w,7Q,s6,T9,Un,Ls,3D,w3,u0,pW,R1".split(
    ","
  );

const arregloCaracteresBasicos =
  "a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z,A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z".split(
    ","
  );
// const TWILIO_SID = process.env.TWILIO_SID;
// const TWILIO_TOKEN = process.env.TWILIO_TOKEN;

const desencriptar = (cadenaEncriptada) => {
  const cadenaNueva2 = Buffer.from(cadenaEncriptada, "base64").toString(
    "utf-8"
  );
  let cadenaDesencriptada = "";

  for (let i = 0; i < cadenaNueva2.length; i += 2) {
    const parLetras = cadenaNueva2.substring(i, i + 2);
    const indice = arregloModificador.indexOf(parLetras);
    if (indice !== -1) {
      cadenaDesencriptada += arregloCaracteres[indice];
    }
  }

  return cadenaDesencriptada;
};

const encriptar = (cadenaDesencriptada) => {
  let cadenaEncriptada = "";

  for (let i = 0; i < cadenaDesencriptada.length; i++) {
    const letra = cadenaDesencriptada[i];
    const indice = arregloCaracteres.indexOf(letra);
    if (indice !== -1) {
      cadenaEncriptada += arregloModificador[indice];
    }
  }

  return Buffer.from(cadenaEncriptada).toString("base64");
};

const validarPassword = (password, passwordEncriptada) => {
  return desencriptar(passwordEncriptada) === password;
};

const generatePassword = () => {
  let password = "";
  for (let i = 0; i < 10; i++) {
    password +=
      arregloCaracteresBasicos[
        Math.floor(Math.random() * arregloCaracteresBasicos.length)
      ];
  }
  return password;
};

const deleteFile = (path) => {
  try {
    // fs.existsSync(path) && fs.unlinkSync(path);

    if (fs.existsSync(path)) {
      fs.unlinkSync(path);
    } else {
      console.log("El archivo no existe, no se puede eliminar " + path);
    }
  } catch (error) {
    console.log(error);
  }
};

const sendWhatsapp = async ({ to, message }) => {
  try {
    const response = await client.messages.create({
      contentSid: "HX8055b5e505911f04c76b56fdc49a5737",
      from: "whatsapp:+5215541629880",
      to: `whatsapp:+521${to}`,
      contentVariables: JSON.stringify({ 1: message }),
      messagingServiceSid: process.env.TWILIO_MESSAGING_SERVICE_SID,
    });

    return response;
  } catch (error) {
    console.log(error);
  }
};
const sendWhatsappEvent = async ({
  to,
  evento,
  descripcion,
  fechaInicio,
  horaInicio,
  fechaFinal,
  horaFinal,
  responsable,
}) => {
  try {
    const response = await client.messages.create({
      contentSid: "HX7c00316de445514b729a1bbe24655d9c",
      from: "whatsapp:+5215541629880",
      to: `whatsapp:+521${to}`,
      contentVariables: JSON.stringify({
        1: responsable,
        2: evento,
        3: descripcion,
        4: fechaInicio,
        5: horaInicio,
        6: fechaFinal,
        7: horaFinal,
      }),
      messagingServiceSid: process.env.TWILIO_MESSAGING_SERVICE_SID,
    });

    console.log(response);
    return response;
  } catch (error) {
    console.log(error);
  }
};

const sendWhatsappMovimiento = async ({ to, var1, var2, var3, url }) => {
  try {
    const response = await client.messages.create({
      contentSid: "HX5ed812b3af75bb3cbc5f1204da259ae3",
      from: "whatsapp:+5215541629880",
      to: `whatsapp:+521${to}`,
      contentVariables: JSON.stringify({ 1: var1, 2: var2, 3: var3, 4: url }),
      messagingServiceSid: process.env.TWILIO_MESSAGING_SERVICE_SID,
    });

    return response;
  } catch (error) {
    console.log(error);
  }
};

const sendWhatsappRecovery = async ({ to, correo, password, url }) => {
  try {
    const response = await client.messages.create({
      contentSid: "HX42ba414234b050f4a60503cdaef119e6",
      from: "whatsapp:+5215541629880",
      to: `whatsapp:+521${to}`,
      contentVariables: JSON.stringify({
        1: correo,
        2: password,
        3: url,
        4: " ",
      }),
      messagingServiceSid: process.env.TWILIO_MESSAGING_SERVICE_SID,
    });

    return response;
  } catch (error) {
    console.log(error);
  }
};

const formatDate = (date) => {
  const moment = require("moment");
  if (!date) {
    console.log("No date provided");
    return "";
  }

  // Usa moment para convertir y formatear la fecha
  const dateObj = moment(date, "DD/MM/YYYY, hh:mm A").toDate();

  if (isNaN(dateObj.getTime())) {
    console.log("Invalid date:", date);
    return "Fecha inválida";
  }

  return new Intl.DateTimeFormat("es-ES", {
    year: "numeric",
    month: "2-digit",
    day: "2-digit",
  }).format(dateObj);
};

const formatDateTime = (date) => {
  if (!date) {
    return null;
  }

  const options = {
    year: "numeric",
    month: "2-digit",
    day: "2-digit",
    hour: "2-digit",
    minute: "2-digit",
    hourCycle: "h12",
  };

  const formattedDate = new Intl.DateTimeFormat("es-ES", options).format(
    new Date(date)
  );

  // Convertir "a. m." y "p. m." a "AM" y "PM" eliminando espacios no divisibles
  return formattedDate
    .replace(" a. m.", " AM")
    .replace(" p. m.", " PM")
    .replace(" a. m.", " AM")
    .replace(" p. m.", " PM");
};

const formaTime = (date) => {
  if (!date) {
    return null;
  }

  const options = {
    hour: "2-digit",
    minute: "2-digit",
    hourCycle: "h12",
  };

  const formattedDate = new Intl.DateTimeFormat("es-ES", options).format(
    new Date(date)
  );

  // Convertir "a. m." y "p. m." a "AM" y "PM" eliminando espacios no divisibles
  return formattedDate.replace(" a. m.", " AM").replace(" p. m.", " PM");
};

const convertSize = (bytes) => {
  const sizes = ["Bytes", "KB", "MB", "GB", "TB"];
  if (bytes === 0) {
    return "0 Byte";
  }
  const i = parseInt(Math.floor(Math.log(bytes) / Math.log(1024)));
  return Math.round(bytes / Math.pow(1024, i), 2) + " " + sizes[i];
};

const createPDF = ({ html, filename, values = {}, res }) => {
  try {
    const PDFDocument = require("pdfkit");
    const fs = require("fs");

    const contente = html(values);

    const doc = new PDFDocument();

    // Guardar el PDF en el sistema de archivos
    doc.pipe(fs.createWriteStream("output.pdf"));

    // Convertir HTML a texto plano

    // Agregar el texto convertido al PDF
    doc.fontSize(12).text(contente, 100, 100);

    // Finalizar el documento
    doc.end();

    // descargar el archivo
    res.download("output.pdf", filename);

    return res;
  } catch (error) {
    console.error("Error generating PDF:", error);
    return res.status(500).json({
      message: "Error generating PDF. Please try again later.",
      error: error.message,
    });
  } finally {
    // Asegúrate de que el navegador se cierra independientemente del resultado
  }
};

const formatMoney = (number) => {
  try {
    if (isNaN(number)) return "0.00";

    const formattedNumber = Number(number).toLocaleString("es-MX", {
      style: "currency",
      currency: "MXN",
      minimumFractionDigits: 2,
      maximumFractionDigits: 2,
    });

    return formattedNumber;
  } catch (error) {
    console.error(error);
    return "0.00"; // Puedes ajustar el formato según tus necesidades
  }
};

const enviaCodigoWhatsApp = async ({ codigo, to }) => {
  try {
    const response = await client.messages.create({
      contentSid: "HXa7645178cc40fe09172737c4c218b744",
      from: `whatsapp:${process.env.TWILIO_PHONE_FROM}`,
      to: `whatsapp:+521${to}`,
      contentVariables: JSON.stringify({ 1: codigo }),
      messagingServiceSid: process.env.TWILIO_MESSAGING_SERVICE_SID,
    });

    return response;
  } catch (error) {
    console.log(error);
  }
};

const sendWhatsappRecovery2 = async ({
  idDespacho,
  nombreUsuario,
  to,
  correo,
  url,
}) => {
  try {
    let logo = "";
    let nombreDespacho = " ";

    if (idDespacho == null) {
      logo = "default/imagen_meta_iusform.png";
      nombreDespacho = "Distribuidor";
    } else {
      const findDespacho = await DespachoModel.findById(idDespacho).select(
        "logo nombre"
      );

      if (findDespacho && findDespacho?.logo) {
        logo = `despachos/${findDespacho?._id}/logo/${findDespacho?.logo}`;
        nombreDespacho = findDespacho?.nombre || " ";
      } else {
        logo = "default/imagen_meta_iusform.png";
      }
    }

    const contentVariables = JSON.stringify({
      1: nombreUsuario,
      2: nombreDespacho,
      3: correo,
      4: url,
      5: logo,
    });

    const response = await client.messages.create({
      contentSid: "AC50666abe1490c40fc38edf7c175516be", //s
      from: "whatsapp:+5215541629880",
      to: `whatsapp:+521${to}`,
      contentVariables,
      messagingServiceSid: process.env.TWILIO_MESSAGING_SERVICE_SID,
    });

    return response;
  } catch (error) {
    console.error(error);
  }
};

const generateRandomNumbers = () => {
  const numbers = [];
  for (let i = 0; i < 6; i++) {
    const randomNumber = Math.floor(Math.random() * 10); // Genera un número entre 0 y 9
    numbers.push(randomNumber);
  }
  return numbers.join(""); // Une los números en una cadena
};

module.exports = {
  desencriptar,
  encriptar,
  validarPassword,
  generatePassword,
  deleteFile,
  sendWhatsapp,
  sendWhatsappEvent,
  sendWhatsappRecovery,
  sendWhatsappMovimiento,
  formatDate,
  formatDateTime,
  convertSize,
  createPDF,
  formatMoney,
  formaTime,
  enviaCodigoWhatsApp,
  generateRandomNumbers,
  sendWhatsappRecovery2,
};
