require('colors');
const { MONGODB_URI } = require('../config/index.js'); // Cargar la URI desde la configuración
const mongoose = require('mongoose');

mongoose.set('strictQuery', true);

const connectToMongoDB = async () => {
  try {
    await mongoose.connect(MONGODB_URI, {
      useNewUrlParser: true,
      useUnifiedTopology: true,
      serverSelectionTimeoutMS: 5000,
      socketTimeoutMS: 45000,
      enableUtf8Validation: false,
    });

    console.log('\nConnected to MongoDB!!!\n'.white.bold); // Mensaje de éxito
  } catch (err) {
    console.error('\nCould not connect to MongoDB\n'.red, err); // Mensaje de error
  }
};

connectToMongoDB();
