const DESPACHO_APP = process.env.DESPACHO_APP;

const RegistroUsuarioHTML = (
  nombre,
  usuario,
  password,
  url = DESPACHO_APP,
  nuevo = false
) => {
  const year = new Date().getFullYear();

  const mensajeIntro = nuevo
    ? `Hola <strong>${nombre}</strong>,<br /> para poder ingresar a Nildda, da clic en el link y crea tu contraseña`
    : `Hola <strong>${nombre}</strong>,<br />a continuación te enviamos tus datos de acceso a nuestra plataforma:`;

  const filaPassword = !nuevo
    ? `<tr>
         <td style="width:30%; background-color:#021D49; color:#FFFFFF; font-weight:bold; padding:5px;">Contraseña:</td>
         <td style="width:70%; background-color:#F2F2F2; color:#0F181F; font-weight:bold; padding:5px;">
           ${password}
         </td>
       </tr>`
    : "";

  return `
    <table border="0" cellspacing="0" cellpadding="0" style="width:100%; background-color:#fffdf9;margin:0px !important;">
      <tr>
        <td style="width:100%; padding:20px;">
          <table style="width:700px;" border="0" align="center" cellpadding="0" cellspacing="0">
            <tr>
              <td style="width:100%;background-color: #FFFFFF !important; padding: 20px; vertical-align:top;">
                <!-- Cabecera -->
                <table style="width:100%;" border="0" align="center" cellpadding="0" cellspacing="0">
                  <tr>
                    <td style="width:50%; text-align:left;"><img src="https://nildda.com/assets/_email-hidden-assets-2025/logo_nildda_horizontal_positivo.png" width="215" title="NILDDA" alt="NILDDA" /></td>
                    <td style="width:50%; text-align:right; font-family: Arial, Helvetica, sans-serif; font-size:18px; color:#0F181F; font-weight:bold;">
                      <div style="font-size:16px; text-transform:uppercase;">Bienvenido a NILDDA</div>
                      <div style="font-size:15px; font-weight:normal;">Gracias por registrarte</div>
                    </td>
                  </tr>
                </table>

                <hr style="border: none; border-top: 2px solid #CDCDCD; margin: 20px 0;" />

                <p style="font-family: Arial, Helvetica, sans-serif; font-size:14px; color:#0F181F;">
                  ${mensajeIntro}
                </p>

                <!-- Tabla de acceso -->
                <table style="width:100%;" border="0" cellpadding="0" cellspacing="0">
                  <tr>
                    <td style="width:30%; background-color:#021D49; color:#FFFFFF; font-weight:bold; padding:5px;">URL:</td>
                    <td style="width:70%; background-color:#F2F2F2; color:#0F181F; font-weight:bold; padding:5px;">
                      <a href="${url}" target="_blank" style="color:#0F181F; text-decoration:none;">${url}</a>
                    </td>
                  </tr>
                  <tr>
                    <td style="width:30%; background-color:#021D49; color:#FFFFFF; font-weight:bold; padding:5px;">Correo:</td>
                    <td style="width:70%; background-color:#F2F2F2; color:#0F181F; font-weight:bold; padding:5px;">
                      ${usuario}
                    </td>
                  </tr>
                  ${filaPassword}
                </table>

                <hr style="border: none; border-top: 2px solid #CDCDCD; margin: 20px 0;" />

                <p style="font-family: Arial, Helvetica, sans-serif; font-size:12px; color:#5C5A5B; text-align:center;">
                  <a href="https://nildda.com/contacto/" target="_blank" style="color:#5C5A5B; text-decoration:none;">Contacto</a> | 
                  <a href="https://nildda.com/aviso_de_privacidad/" target="_blank" style="color:#5C5A5B; text-decoration:none;">Aviso de Privacidad</a>
                </p>

                <div style="text-align:center; padding:10px;">
                  <a href="https://nildda.com/" target="_blank">
                    <img src="https://nildda.com/assets/_email-hidden-assets-2025/icono_footer_25x25_nildda.png" width="20" alt="NILDDA Icon" />
                  </a>
                  &nbsp;
                  <a href="https://www.posibilidades.com.mx/" target="_blank">
                    <img src="https://nildda.com/assets/_email-hidden-assets-2025/icono_footer_25x25_psd.png" width="20" alt="Posibilidades Icon" />
                  </a>
                </div>
                
                <p style="font-family: Arial, Helvetica, sans-serif; font-size:12px; text-align:center; color:#5C5A5B;">
                  © ${year} <a href="https://nildda.com" style="color:#021D49; text-decoration:none;">nildda</a> |
                  Design by: <a href="https://www.posibilidades.com.mx/" style="color:#021D49; text-decoration:none;">Posibilidades</a>
                </p>
              </td>
            </tr>
          </table>
        </td>
      </tr>
    </table>
  `;
};

module.exports = {
  RegistroUsuarioHTML,
};
