const MovimientosExpedienteHTML = ({
  nombreCliente,
  nombreExpediente,
  nombreRemitente,
  accionRealizada,
  detallesAdicionales,
  fechaMovimiento,
  enlaceExpediente,
}) => {
  const year = new Date().getFullYear();

  return `
    <!DOCTYPE html>
    <html lang="en">

    <head>
        <meta charset="utf-8">
        <style>
            body {
                font-family: 'Helvetica', 'Arial', sans-serif;
                margin: 0;
                padding: 0;
                background-color: #F2F2F2;
                color: #232323;
            }

            table {
                width: 600px;
                margin: 0 auto;
            }

            td {
                padding: 10px;
            }

            .header {
                background-color: #F2F2F2;
                text-align: center;
            }

            .header img {
                width: 200px;
            }

            .banner img {
                width: 100%;
            }

            .content {
                background-color: #FFFFFF;
                padding-right: 20px;
                padding-left: 20px;
                padding-bottom: 20px;
                padding-top: 30px;
            }

            .content p {
                font-size: 14px;
                line-height: 23px;
                margin-bottom: 15px;
            }

            .button {
                display: inline-block;
                padding: 10px 20px;
                background-color: #c89211;
                color: #ffffff;
                text-decoration: none;
                border: none;
                border-radius: 5px;
                cursor: pointer;
            }

            .button:hover {
                background-color: #a1780b;
            }

            .footer {
                border-bottom-style: dashed;
                border-bottom-width: 1px;
                border-bottom-color: #cccccc;
                margin-top: 20px;
            }

            .footer p {
                font-size: 12px;
                color: #685f5f;
                line-height: 23px;
                text-align: center;
                margin: 0;
            }

            .footer a {
                color: #54c8e8;
                text-decoration: none;
            }
        </style>
    </head>

    <body>

        <table>
            <tr>
                <td class="header">
                  <img src="https://nildda.com/assets/_email-hidden-assets-2025/logo_nildda_horizontal_positivo.png" alt="NILDDA Logo" style="max-width: 300px; height: auto;">
                </td>
            </tr>
            <tr>
                <td class="banner">
                    <img src="https://ci3.googleusercontent.com/meips/ADKq_NYwwSEyP0-Zf9iZm2_ArqgxiQPAj2L3ImphGwnvfvf7ByFwCt74U5RKE3IDLMHCPqLWqWC_DKM_sskhY2mZ7f-eMVkMKbvJKQiV56BcY83FCAXNakENFY8Ksg=s0-d-e1-ft#http://nildda.com/administrador/images/banners/banner_540x130_1.jpg" alt="Banner" />
                </td>
            </tr>
            <tr>
                <td class="content">
                    <p style="font-size: 18px; font-weight: bold;">¡Hola ${nombreCliente}!</p>
                    <p><strong>${nombreRemitente}</strong> ha realizado la siguiente acción:</p>
                    <p>${accionRealizada}</p>
                    <p>${detallesAdicionales}</p>
                    <p>Esta acción se llevó a cabo el <strong>${fechaMovimiento}</strong>.</p>
                    <p>No dudes en contactarnos si necesitas más información o tienes alguna pregunta.</p>
                    <a class="button" style="background-color: #021d49; color: #ffffff; text-decoration: none; border: none; border-radius: 5px; cursor: pointer; display: inline-block; padding: 10px 20px;"
                     href="${enlaceExpediente}">Ver Expediente</a>
                </td>
            </tr>
            <tr>
                <td
                    style="width:100%;font-family: Helvetica, Arial, sans-serif; font-size:14px; color:#232323; line-height:23px; text-align:center; vertical-align:top; width: normal;">
                    Si tienes dudas ó comentarios, comunícate con nosotros.<br />
                    <span style="font-weight:600;">
                        <img src="http://nildda.com/administrador/images/notificaciones/icono_contacto_whatsapp.png"
                            width="16" height="16" alt="" />
                        <a href="https://api.whatsapp.com/send?phone=522229299899" target="_blank"
                            title="Envíanos un mensaje de WhatsApp" alt="Envíanos un mensaje de WhatsApp"
                            style="color:#685f5f; text-decoration:none;">22 29 29 98 99</a>&nbsp;&nbsp;&nbsp;
                        <img src="http://nildda.com/administrador/images/notificaciones/icono_contacto_email.png"
                            width="16" height="16" alt="" />
                        <a href="mailto:contacto@nildda.com.mx" target="_blank"
                            title="Escríbenos a nuestro correo electrónico" alt="Escríbenos a nuestro correo electrónico"
                            style="color:#021d49; text-decoration:none;">contacto@nildda.com.mx</a>
                    </span>
                </td>
            </tr>
            <tr class="footer">
                <td>
                    <p>&copy; ${year} Derechos Reservados | <a href="http://nildda.com/administrador/" target="_blank">nildda
                            - Plataforma de proyectos</a></p>
                </td>
            </tr>
        </table>

    </body>

    </html>

  `;
};

module.exports = { MovimientosExpedienteHTML };
