const ExpedienteHTML = (expediente) => {
  const {
    numeroExpediente,
    titulo,
    juicio,
    folioInterno,
    fechaInicio,
    ultimoMovimiento,
    cliente,
    procedimiento,
    juzgado,
    materia,
    etapaProcesal,
    responsable,
    movimientos,
    partesInvolucradas,
    notas,
    gastos,
    ingresos,
    documentosAdjuntos,
    recursos,
    agenda,
    usuarios,
    incidencias,
    logo,
    nombreDespacho,
  } = expediente;

  const movimientosHTML = movimientos
    ?.map(
      (movimiento) => `
    <tr>
      <td style="border: 1px solid #ddd; padding: 8px; background-color: #fff; font-size: 12px;">${movimiento.fecha}</td>
      <td style="border: 1px solid #ddd; padding: 8px; background-color: #fff; font-size: 12px;">${movimiento.titulo}</td>
      <td style="border: 1px solid #ddd; padding: 8px; background-color: #fff; font-size: 12px;">${movimiento.descripcion}</td>
      <td style="border: 1px solid #ddd; padding: 8px; background-color: #fff; font-size: 12px;">${movimiento.responsable}</td>
    </tr>
  `
    )
    .join("");

  const partesInvolucradasHTML = partesInvolucradas
    ?.map(
      (parte) => `
    <p style="margin: 5px 0; font-size: 12px;"><strong>${parte.rol}:</strong> ${parte?.nombre}</p>
  `
    )
    .join("");

  const notasHTML = notas
    ?.map(
      (nota) => `
  <div style="margin: 10px 0; border-bottom: 1px solid #ccc; padding-bottom: 5px;">
    <p style="margin: 0; font-size: 12px; font-weight: bold;">${nota.descripcion}</p>
    <p style="margin: 0; font-size: 10px; color: #666;">
      Hecho por: ${nota.responsable} | Fecha: ${nota.fecha}
    </p>
  </div>
`
    )
    .join("");

  const gastosHTML = gastos
    ?.map(
      (gasto) => `
    <tr>
      <td style="border: 1px solid #ddd; padding: 8px; background-color: #fff; font-size: 12px;">${gasto.fecha}</td>
      <td style="border: 1px solid #ddd; padding: 8px; background-color: #fff; font-size: 12px;">${gasto.concepto}</td>
      <td style="border: 1px solid #ddd; padding: 8px; background-color: #fff; font-size: 12px;">${gasto.monto}</td>
    </tr>
  `
    )
    .join("");

  const ingresosHTML = ingresos
    ?.map(
      (ingreso) => `
    <tr>
      <td style="border: 1px solid #ddd; padding: 8px; background-color: #fff; font-size: 12px;">${ingreso.fecha}</td>
      <td style="border: 1px solid #ddd; padding: 8px; background-color: #fff; font-size: 12px;">${ingreso.concepto}</td>
      <td style="border: 1px solid #ddd; padding: 8px; background-color: #fff; font-size: 12px;">${ingreso.monto}</td>
    </tr>
  `
    )
    .join("");

  const documentosAdjuntosHTML = documentosAdjuntos
    ?.map(
      (doc) => `
  <p style="margin: 5px 0; font-size: 12px;">
    <strong>${doc?.nombre}:</strong> 
    <a href="${doc.url}" target="_blank">
      Ver documento
    </a>
  </p>
`
    )
    .join("");

  const recursosHTML = recursos
    ?.map(
      (ri) => `
    <tr>
      <td style="border: 1px solid #ddd; padding: 8px; background-color: #fff; font-size: 12px;">${ri.fecha}</td>
      <td style="border: 1px solid #ddd; padding: 8px; background-color: #fff; font-size: 12px;">${ri?.nombre}</td>
      <td style="border: 1px solid #ddd; padding: 8px; background-color: #fff; font-size: 12px;">${ri.descripcion}</td>
      <td style="border: 1px solid #ddd; padding: 8px; background-color: #fff; font-size: 12px;">${ri.responsable}</td>
    </tr>
  `
    )
    .join("");

  const incidenciasHTML = incidencias
    ?.map(
      (incidencia) => `
    <tr>
      <td style="border: 1px solid #ddd; padding: 8px; background-color: #fff; font-size: 12px;">${incidencia.fecha}</td>
      <td style="border: 1px solid #ddd; padding: 8px; background-color: #fff; font-size: 12px;">${incidencia?.nombre}</td>
      <td style="border: 1px solid #ddd; padding: 8px; background-color: #fff; font-size: 12px;">${incidencia.descripcion}</td>
      <td style="border: 1px solid #ddd; padding: 8px; background-color: #fff; font-size: 12px;">${incidencia.responsable}</td>
    </tr>
  `
    )
    .join("");

  const agendaHTML = agenda
    ?.map(
      (evento) => `
    <tr>
      <td style="border: 1px solid #ddd; padding: 8px; background-color: #fff; font-size: 12px;">${evento.fecha}</td>
      <td style="border: 1px solid #ddd; padding: 8px; background-color: #fff; font-size: 12px;">${evento.titulo}</td>
      <td style="border: 1px solid #ddd; padding: 8px; background-color: #fff; font-size: 12px;">${evento.descripcion}</td>
      <td style="border: 1px solid #ddd; padding: 8px; background-color: #fff; font-size: 12px;">${evento.responsable}</td>
    </tr>
  `
    )
    .join("");

  const usuariosHTML = usuarios
    ?.map(
      (usuario) => `
    <p style="margin: 5px 0; font-size: 12px;"><strong>${usuario.rol}:</strong> ${usuario?.nombre}</p>
  `
    )
    .join("");

  return `<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Document</title>
    <style>
  * {
  font-size: 12px;
}

  </style>
</head>


  <body style="font-family: Arial, sans-serif; margin: 0; padding: 0;">
  ${
    logo
      ? `
 <table width="100%" border="0" cellspacing="0" cellpadding="0 id="pageHeader">
    <tr>
      <td align="left" valign="top"
        style="text-align:left !important; padding-left:20px;background-image: url('https://nildda.com/images/logo/background_top.jpg'); background-position:top; background-repeat:no-repeat; background-size:cover;">
          <img src="${logo}" style="width="120" height="60"  object-fit: contain;"> <span>${nombreDespacho}</span>
      </td>
    </tr>
  </table>
  `
      : ""
  }
    <div style="font-family: Arial, sans-serif; max-width: 900px; margin: 0 auto; padding: 20px; font-size: 14px;">
      <div style="display: flex; justify-content: space-between; margin-bottom: 20px;">
        <div style="width: 100%;">
          <p style="margin: 5px 0; font-size: 14px;"><strong>No. Expediente:</strong> ${
            numeroExpediente || ""
          }</p>
          <p style="margin: 5px 0; font-size: 14px;"><strong>Título:</strong> ${
            titulo || ""
          }</p>
          <p style="margin: 5px 0; font-size: 14px;"><strong>Trabajo o servicio:</strong> ${
            juicio || ""
          }</p>
          <p style="margin: 5px 0; font-size: 14px;"><strong>Folio interno:</strong> ${
            folioInterno || ""
          }</p>
          <p style="margin: 5px 0; font-size: 14px;"><strong>Fecha inicio:</strong> ${
            fechaInicio || ""
          }</p>
          <p style="margin: 5px 0; font-size: 14px;"><strong>Último movimiento:</strong> ${
            ultimoMovimiento || ""
          }</p>
        </div>
        <div style="width: 100%;">
          <p style="margin: 5px 0; font-size: 14px;"><strong>Cliente:</strong> ${
            cliente || ""
          }</p>
          <p style="margin: 5px 0; font-size: 14px;"><strong>Procedimiento:</strong> ${
            procedimiento || ""
          }</p>
          <p style="margin: 5px 0; font-size: 14px;"><strong>Juzgado:</strong> ${
            juzgado || ""
          }</p>
          <p style="margin: 5px 0; font-size: 14px;"><strong>Materia:</strong> ${
            materia || ""
          }</p>
          <p style="margin: 5px 0; font-size: 14px;"><strong>Etapa:</strong> ${
            etapaProcesal || ""
          }</p>
          <p style="margin: 5px 0; font-size: 14px;"><strong>Responsable:</strong> ${
            responsable || ""
          }</p>
        </div>
      </div>

      ${
        usuarios?.length > 0
          ? `
      <h2 style="color: #54c8e8; margin-bottom: 15px; font-size: 16px;">Abogados</h2>
      <div style="margin-bottom: 20px;">
        ${usuariosHTML}
      </div>
      `
          : ""
      }
     
      ${
        partesInvolucradas?.length > 0
          ? `
      <h2 style="color: #54c8e8; margin-bottom: 15px; font-size: 16px;">Partes Involucradas</h2>
      <div style="margin-bottom: 20px;">
        ${partesInvolucradasHTML}
      </div>
      `
          : ""
      }
      
      ${
        notas?.length > 0
          ? `
      <h2 style="color: #54c8e8; margin-bottom: 15px; font-size: 16px;">Notas</h2>
      <div style="margin-bottom: 20px;">
        ${notasHTML}
      </div>
      `
          : ""
      }
      
    ${
      gastos?.length > 0
        ? `
      <h2 style="color: #54c8e8; margin-bottom: 15px; font-size: 16px;">Gastos</h2>
      <table style="width: 100%; border-collapse: collapse; margin-bottom: 20px;">
        <thead>
          <tr>
            <th style="border: 1px solid #ddd; padding: 8px; text-align: left; background-color: #f5f5f5; color: #333; font-size: 14px;">Fecha</th>
            <th style="border: 1px solid #ddd; padding: 8px; text-align: left; background-color: #f5f5f5; color: #333; font-size: 14px;">Concepto</th>
            <th style="border: 1px solid #ddd; padding: 8px; text-align: left; background-color: #f5f5f5; color: #333; font-size: 14px;">Monto</th>
          </tr>
        </thead>
        <tbody>
          ${gastosHTML}
        </tbody>
      </table>
    `
        : ""
    }

      ${
        ingresos?.length > 0
          ? `
      <h2 style="color: #54c8e8; margin-bottom: 15px; font-size: 16px;">Ingresos</h2>
      <table style="width: 100%; border-collapse: collapse; margin-bottom: 20px;">
        <thead>
          <tr>
            <th style="border: 1px solid #ddd; padding: 8px; text-align: left; background-color: #f5f5f5; color: #333; font-size: 14px;">Fecha</th>
            <th style="border: 1px solid #ddd; padding: 8px; text-align: left; background-color: #f5f5f5; color: #333; font-size: 14px;">Concepto</th>
            <th style="border: 1px solid #ddd; padding: 8px; text-align: left; background-color: #f5f5f5; color: #333; font-size: 14px;">Monto</th>
          </tr>
        </thead>
        <tbody>
          ${ingresosHTML}
        </tbody>
      </table>
    `
          : ""
      }
      
    ${
      documentosAdjuntos?.length > 0
        ? `
      <h2 style="color: #54c8e8; margin-bottom: 15px; font-size: 16px;">Documentos Adjuntos</h2>
      <div style="margin-bottom: 20px;">
        ${documentosAdjuntosHTML}
      </div>
      <h2 style="color: #54c8e8; margin-bottom: 15px; font-size: 16px;">Recursos</h2>
      <table style="width: 100%; border-collapse: collapse; margin-bottom: 20px;">
        <thead>
          <tr>
            <th style="border: 1px solid #ddd; padding: 8px; text-align: left; background-color: #f5f5f5; color: #333; font-size: 14px;">Fecha</th>
            <th style="border: 1px solid #ddd; padding: 8px; text-align: left; background-color: #f5f5f5; color: #333; font-size: 14px;">Nombre</th>
            <th style="border: 1px solid #ddd; padding: 8px; text-align: left; background-color: #f5f5f5; color: #333; font-size: 14px;">Comentario</th>
            <th style="border: 1px solid #ddd; padding: 8px; text-align: left; background-color: #f5f5f5; color: #333; font-size: 14px;">Responsable</th>
          </tr>
        </thead>
        <tbody>
          ${recursosHTML}
        </tbody>
      </table>
    `
        : ""
    }
      
      ${
        incidencias?.length > 0
          ? `
        <h2 style="color: #54c8e8; margin-bottom: 15px; font-size: 16px;">Incidencias</h2>
      <table style="width: 100%; border-collapse: collapse; margin-bottom: 20px;">
        <thead>
          <tr>
            <th style="border: 1px solid #ddd; padding: 8px; text-align: left; background-color: #f5f5f5; color: #333; font-size: 14px;">Fecha</th>
            <th style="border: 1px solid #ddd; padding: 8px; text-align: left; background-color: #f5f5f5; color: #333; font-size: 14px;">Nombre</th>
            <th style="border: 1px solid #ddd; padding: 8px; text-align: left; background-color: #f5f5f5; color: #333; font-size: 14px;">Comentario</th>
            <th style="border: 1px solid #ddd; padding: 8px; text-align: left; background-color: #f5f5f5; color: #333; font-size: 14px;">Responsable</th>
          </tr>
        </thead>
        <tbody>
          ${incidenciasHTML}
        </tbody>
      </table>
      `
          : ""
      }
      
    ${
      agenda?.length > 0
        ? `
      <h2 style="color: #54c8e8; margin-bottom: 15px; font-size: 16px;">Agenda</h2>
      <table style="width: 100%; border-collapse: collapse; margin-bottom: 20px;">
        <thead>
          <tr>
            <th style="border: 1px solid #ddd; padding: 8px; text-align: left; background-color: #f5f5f5; color: #333; font-size: 14px;">Fecha</th>
            <th style="border: 1px solid #ddd; padding: 8px; text-align: left; background-color: #f5f5f5; color: #333; font-size: 14px;">Titulo</th>
            <th style="border: 1px solid #ddd; padding: 8px; text-align: left; background-color: #f5f5f5; color: #333; font-size: 14px;">Descripción</th>
            <th style="border: 1px solid #ddd; padding: 8px; text-align: left; background-color: #f5f5f5; color: #333; font-size: 14px;">Responsable</th>
          </tr>
        </thead>
        <tbody>
          ${agendaHTML}
        </tbody>
      </table>
    `
        : ""
    }
      
    ${
      movimientos?.length > 0
        ? `
      <h2 style="color: #54c8e8; margin-bottom: 15px; font-size: 16px;">Movimientos</h2>
      <table style="width: 100%; border-collapse: collapse; margin-bottom: 20px;">
        <thead>
          <tr>
            <th style="border: 1px solid #ddd; padding: 8px; text-align: left; background-color: #f5f5f5; color: #333; font-size: 14px;">Fecha</th>
            <th style="border: 1px solid #ddd; padding: 8px; text-align: left; background-color: #f5f5f5; color: #333; font-size: 14px;">Título</th>
            <th style="border: 1px solid #ddd; padding: 8px; text-align: left; background-color: #f5f5f5; color: #333; font-size: 14px;">Descripción</th>
            <th style="border: 1px solid #ddd; padding: 8px; text-align: left; background-color: #f5f5f5; color: #333; font-size: 14px;">Responsable</th>
          </tr>
        </thead>
        <tbody>
          ${movimientosHTML}
        </tbody>
      </table>
    `
        : ""
    }
    </div>
     <table width="100%" border="0" cellspacing="0" cellpadding="0" id="">

     <table border="0" align="center" cellpadding="0" cellspacing="0" style="width:100%; padding: 0px; margin: 0px;">
      <tr>
        <td align="left" valign="middle" style="width:40%; padding: 8px;">
          <table border="0" align="center" cellpadding="0" cellspacing="0" style="width:100%;">
            <tr>
              <td align="center" valign="middle" style="width:20%; background-color:#101820; font-size:5px; padding: 8px;">
                &nbsp;
              </td>
              <td align="center" valign="middle" style="width:80%; background-color:#54c8e8; font-size:5px; padding: 8px;">
                &nbsp;
              </td>
            </tr>
          </table>
        </td>
        <td align="left" valign="middle" style="width:60%;">
          <table border="0" align="center" cellpadding="0" cellspacing="0" style="width:100%;">
            <tr>
              <td align="left" valign="middle"
                style="width:50%; text-align:left; color:#101820; font-weight:bold; font-size:13px; font-size:10px;">
                www.nildda.com
              </td>
              <td align="left" valign="middle"
                style="width:50%; text-align:left; color:#101820; font-weight:bold; font-size:13px; font-size:10px;">
                contacto@nildda.com</td>
            </tr>
          </table>
        </td>
      </tr>
    </table>
    </body>
</html>
  `;
};

module.exports = {
  ExpedienteHTML,
};
